/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.util;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.webbeans.BindingType;
import javax.webbeans.ExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflections {
    public static Class<?> classForName(String name) throws ClassNotFoundException {
        return Reflections.classForName(name, Thread.currentThread().getContextClassLoader());
    }

    public static Class<?> classForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return classLoader.loadClass(name);
        }
        catch (Exception e) {
            return Class.forName(name);
        }
    }

    public static String getPropertyName(Method method) {
        String methodName = method.getName();
        if (methodName.matches("^(get).*") && method.getParameterTypes().length == 0) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.matches("^(is).*") && method.getParameterTypes().length == 0) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        return null;
    }

    public static boolean isFinal(Class<?> clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static boolean isFinal(Member member) {
        return Modifier.isFinal(member.getModifiers());
    }

    public static boolean isTypeOrAnyMethodFinal(Class<?> type) {
        if (Reflections.isFinal(type)) {
            return true;
        }
        for (Method method : type.getDeclaredMethods()) {
            if (!Reflections.isFinal(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitive(Class<?> type) {
        return type.isPrimitive();
    }

    public static boolean isStatic(Class<?> type) {
        return Modifier.isStatic(type.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isStaticInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && Reflections.isStatic(clazz);
    }

    public static boolean isNonStaticInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !Reflections.isStatic(clazz);
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing constructor (with parameters " + parameterTypes + ") of " + clazz, e);
        }
    }

    public static List<Method> getMethods(Class<?> clazz, Class<? extends Annotation> annotationType) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(annotationType)) continue;
            methods.add(method);
        }
        return methods;
    }

    public static <T> List<Constructor<T>> getAnnotatedConstructors(Class<? extends T> clazz, Class<? extends Annotation> annotationType) {
        ArrayList<Constructor<T>> constructors = new ArrayList<Constructor<T>>();
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (!constructor.isAnnotationPresent(annotationType)) continue;
            constructors.add(constructor);
        }
        return constructors;
    }

    public static <T> List<Constructor<T>> getConstructorsForAnnotatedParameter(Class<? extends T> clazz, Class<? extends Annotation> parameterAnnotationType) {
        ArrayList<Constructor<T>> constructors = new ArrayList<Constructor<T>>();
        for (Constructor<?> constructor : clazz.getConstructors()) {
            Annotation[][] arr$ = constructor.getParameterAnnotations();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = arr$[i$]) {
                    if (!annotation.annotationType().equals(parameterAnnotationType)) continue;
                    constructors.add(constructor);
                }
            }
        }
        return constructors;
    }

    public static <T> List<Constructor<T>> getConstructorsForMetaAnnotatedParameter(Class<? extends T> clazz, Class<? extends Annotation> metaAnnotationType) {
        ArrayList<Constructor<T>> constructors = new ArrayList<Constructor<T>>();
        for (Constructor<?> constructor : clazz.getConstructors()) {
            Annotation[][] arr$ = constructor.getParameterAnnotations();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = arr$[i$]) {
                    if (!annotation.annotationType().isAnnotationPresent(metaAnnotationType)) continue;
                    constructors.add(constructor);
                }
            }
        }
        return constructors;
    }

    public static boolean annotationTypeSetMatches(Set<Class<? extends Annotation>> annotations, Class<? extends Annotation> ... annotationTypes) {
        ArrayList<Class<? extends Annotation>> annotationTypeList = new ArrayList<Class<? extends Annotation>>();
        annotationTypeList.addAll(Arrays.asList(annotationTypes));
        for (Class<? extends Annotation> annotation : annotations) {
            if (annotationTypeList.contains(annotation)) {
                annotationTypeList.remove(annotation);
                continue;
            }
            return false;
        }
        return annotationTypeList.size() == 0;
    }

    public static boolean annotationSetMatches(Set<Annotation> annotations, Class<? extends Annotation> ... annotationTypes) {
        ArrayList<Class<? extends Annotation>> annotationTypeList = new ArrayList<Class<? extends Annotation>>();
        annotationTypeList.addAll(Arrays.asList(annotationTypes));
        for (Annotation annotation : annotations) {
            if (annotationTypeList.contains(annotation.annotationType())) {
                annotationTypeList.remove(annotation.annotationType());
                continue;
            }
            return false;
        }
        return annotationTypeList.size() == 0;
    }

    public static Type[] getActualTypeArguments(Class<?> clazz) {
        if (clazz.getGenericSuperclass() instanceof ParameterizedType) {
            return ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments();
        }
        return new Type[0];
    }

    public static boolean isArrayType(Class<?> rawType) {
        return rawType.isArray();
    }

    public static boolean isParameterizedType(Class<?> type) {
        return type.getTypeParameters().length > 0;
    }

    public static Object invokeAndWrap(Method method, Object instance, Object ... parameters) {
        try {
            return method.invoke(instance, parameters);
        }
        catch (IllegalArgumentException e) {
            throw new ExecutionException("Error invoking method " + method.getName() + " on " + method.getDeclaringClass(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException("Error invoking method " + method.getName() + " on " + method.getDeclaringClass(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("Error invoking method " + method.getName() + " on " + method.getDeclaringClass(), (Throwable)e);
        }
    }

    public static Object invokeAndWrap(String methodName, Class<?>[] parameterTypes, Object instance, Object[] parameterValues) {
        try {
            return instance.getClass().getMethod(methodName, parameterTypes).invoke(instance, parameterValues);
        }
        catch (IllegalArgumentException e) {
            throw new ExecutionException("Error invoking method " + methodName + " on " + instance.getClass(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException("Error invoking method " + methodName + " on " + instance.getClass(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("Error invoking method " + methodName + " on " + instance.getClass(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new ExecutionException("Error invoking method " + methodName + " on " + instance.getClass(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ExecutionException("Error invoking method " + methodName + " on " + instance.getClass(), (Throwable)e);
        }
    }

    public static void setAndWrap(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalArgumentException e) {
            throw new ExecutionException("Error setting field " + field.getName() + " on " + field.getDeclaringClass(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException("Error setting field " + field.getName() + " on " + field.getDeclaringClass(), (Throwable)e);
        }
    }

    public static void setAndWrap(String fieldName, Object target, Object value) {
        try {
            target.getClass().getField(fieldName).set(target, value);
        }
        catch (IllegalArgumentException e) {
            throw new ExecutionException("Error setting field " + fieldName + " on " + target.getClass(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException("Error setting field " + fieldName + " on " + target.getClass(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new ExecutionException("Error setting field " + fieldName + " on " + target.getClass(), (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new ExecutionException("Error setting field " + fieldName + " on " + target.getClass(), (Throwable)e);
        }
    }

    public static Object getAndWrap(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalArgumentException e) {
            throw new ExecutionException("Error getting field " + field.getName() + " on " + field.getDeclaringClass(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException("Error getting field " + field.getName() + " on " + field.getDeclaringClass(), (Throwable)e);
        }
    }

    public static Method lookupMethod(Method method, Object instance) {
        for (Class<?> clazz = instance.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Method targetMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                if (!targetMethod.isAccessible()) {
                    targetMethod.setAccessible(true);
                }
                return targetMethod;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        throw new IllegalArgumentException("Method " + method.getName() + " not implemented by instance");
    }

    public static boolean isProxy(Object instance) {
        return instance.getClass().getName().indexOf("_$$_javassist_") > 0;
    }

    public static Set<Class<?>> getTypeHierachy(Class<?> clazz) {
        HashSet classes = new HashSet();
        if (clazz != null) {
            classes.add(clazz);
            classes.addAll(Reflections.getTypeHierachy(clazz.getSuperclass()));
            for (Class<?> c : clazz.getInterfaces()) {
                classes.addAll(Reflections.getTypeHierachy(c));
            }
        }
        return classes;
    }

    public static boolean isBindingType(Annotation bindingType) {
        boolean isBindingAnnotation = false;
        if (bindingType.annotationType().isAnnotationPresent(BindingType.class)) {
            isBindingAnnotation = true;
        }
        return isBindingAnnotation;
    }
}

