/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Set;
import javax.context.Dependent;
import javax.inject.AmbiguousDependencyException;
import javax.inject.DefinitionException;
import javax.inject.IllegalProductException;
import javax.inject.InconsistentSpecializationException;
import javax.inject.New;
import javax.inject.NullableDependencyException;
import javax.inject.UnproxyableDependencyException;
import javax.inject.UnsatisfiedDependencyException;
import javax.inject.UnserializableDependencyException;
import javax.inject.manager.Bean;
import javax.inject.manager.InjectionPoint;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractProducerBean;
import org.jboss.webbeans.bean.NewEnterpriseBean;
import org.jboss.webbeans.bean.NewSimpleBean;
import org.jboss.webbeans.bean.ProducerMethodBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.metadata.MetaDataCache;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.ListComparator;
import org.jboss.webbeans.util.Proxies;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidator {
    private final ManagerImpl manager;

    public BeanValidator(ManagerImpl manager) {
        this.manager = manager;
    }

    public void validate() {
        ArrayList specializedBeans = new ArrayList();
        for (Bean<?> bean : this.manager.getBeans()) {
            RIBean abstractBean;
            for (InjectionPoint injectionPoint : bean.getInjectionPoints()) {
                if (injectionPoint.getType() instanceof Class) {
                    AbstractProducerBean producerBean;
                    Class type = (Class)injectionPoint.getType();
                    if (injectionPoint.getAnnotation(New.class) != null && injectionPoint.getBindings().size() > 1) {
                        throw new DefinitionException("The injection point " + injectionPoint + " is annotated with @New which cannot be combined with other binding types");
                    }
                    Annotation[] bindings = injectionPoint.getBindings().toArray(new Annotation[0]);
                    Set resolvedBeans = this.manager.resolveByType(type, bindings);
                    if (resolvedBeans.isEmpty()) {
                        throw new UnsatisfiedDependencyException("The injection point " + injectionPoint + " has unsatisfied dependencies for type " + type + " and binding types " + bindings + " in " + bean);
                    }
                    if (resolvedBeans.size() > 1) {
                        throw new AmbiguousDependencyException("The injection point " + injectionPoint + " has ambiguos dependencies for type " + type + " and binding types " + bindings + " in " + bean);
                    }
                    Bean resolvedBean = resolvedBeans.iterator().next();
                    if (MetaDataCache.instance().getScopeModel(resolvedBean.getScopeType()).isNormal() && !Proxies.isClassProxyable(type)) {
                        throw new UnproxyableDependencyException("The injection point " + injectionPoint + " has non-proxyable dependencies");
                    }
                    if (Reflections.isPrimitive((Class)injectionPoint.getType()) && resolvedBean.isNullable()) {
                        throw new NullableDependencyException("The injection point " + injectionPoint + " has nullable dependencies");
                    }
                    if (!(bean instanceof ProducerMethodBean) || !(resolvedBean instanceof AbstractProducerBean) || !(producerBean = (AbstractProducerBean)resolvedBean).getScopeType().equals(Dependent.class) || Reflections.isSerializable(producerBean.getType())) continue;
                    throw new IllegalProductException("Cannot inject @Depedent non-serializable type into " + injectionPoint);
                }
                throw new UnsupportedOperationException("Not yet implemented");
            }
            if (bean instanceof RIBean && !(bean instanceof NewSimpleBean) && !(bean instanceof NewEnterpriseBean) && (abstractBean = (RIBean)bean).isSpecializing()) {
                if (!this.hasHigherPrecedence(bean.getDeploymentType(), abstractBean.getSpecializedBean().getDeploymentType())) {
                    throw new InconsistentSpecializationException("Specializing bean must have a higher precedence deployment type than the specialized bean");
                }
                if (specializedBeans.contains(abstractBean.getSpecializedBean())) {
                    throw new InconsistentSpecializationException("Two beans cannot specialize the same bean");
                }
                specializedBeans.add(abstractBean.getSpecializedBean());
            }
            if (Beans.isPassivatingBean(bean) && !bean.isSerializable()) {
                throw new UnserializableDependencyException("The bean " + bean + " declares a passivating scopes but has non-serializable dependencies");
            }
            boolean normalScoped = MetaDataCache.instance().getScopeModel(bean.getScopeType()).isNormal();
            if (!normalScoped || Beans.isBeanProxyable(bean)) continue;
            throw new UnproxyableDependencyException("Normal scoped bean " + bean + " is not proxyable");
        }
    }

    private boolean hasHigherPrecedence(Class<? extends Annotation> deploymentType, Class<? extends Annotation> otherDeploymentType) {
        ListComparator<Class<? extends Annotation>> comparator = new ListComparator<Class<? extends Annotation>>(this.manager.getEnabledDeploymentTypes());
        return comparator.compare(deploymentType, otherDeploymentType) > 0;
    }
}

