/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.context.Context;
import javax.context.ContextNotActiveException;
import javax.context.CreationalContext;
import javax.event.Observer;
import javax.inject.AmbiguousDependencyException;
import javax.inject.BindingType;
import javax.inject.DeploymentException;
import javax.inject.DuplicateBindingTypeException;
import javax.inject.Production;
import javax.inject.Standard;
import javax.inject.TypeLiteral;
import javax.inject.UnproxyableDependencyException;
import javax.inject.UnsatisfiedDependencyException;
import javax.inject.manager.Bean;
import javax.inject.manager.Decorator;
import javax.inject.manager.InjectionPoint;
import javax.inject.manager.InterceptionType;
import javax.inject.manager.Interceptor;
import javax.inject.manager.Manager;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.bean.NewEnterpriseBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.bean.proxy.ClientProxyProvider;
import org.jboss.webbeans.context.ContextMap;
import org.jboss.webbeans.context.CreationalContextImpl;
import org.jboss.webbeans.ejb.EjbDescriptorCache;
import org.jboss.webbeans.ejb.spi.EjbResolver;
import org.jboss.webbeans.event.EventManager;
import org.jboss.webbeans.event.ObserverImpl;
import org.jboss.webbeans.injection.Resolver;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.jlr.AnnotatedClassImpl;
import org.jboss.webbeans.metadata.MetaDataCache;
import org.jboss.webbeans.resources.spi.NamingContext;
import org.jboss.webbeans.resources.spi.ResourceLoader;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerImpl
implements Manager,
Serializable {
    private static final long serialVersionUID = 3021562879133838561L;
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    public static final String JNDI_KEY = "java:comp/Manager";
    private transient List<Class<? extends Annotation>> enabledDeploymentTypes;
    private final transient EventManager eventManager;
    private final transient ThreadLocal<InjectionPoint> currentInjectionPoint;
    private final transient Resolver resolver;
    private final transient ContextMap contextMap;
    private final transient ClientProxyProvider clientProxyProvider;
    private transient List<Bean<?>> beans;
    private final transient Map<Class<?>, EnterpriseBean<?>> newEnterpriseBeanMap;
    private final transient Map<Class<?>, EnterpriseBean<?>> enterpriseBeanMap;
    private final transient Set<Decorator> decorators;
    private final transient Set<Interceptor> interceptors;
    private final transient EjbResolver ejbResolver;
    private final transient EjbDescriptorCache ejbDescriptorCache;
    private final transient ResourceLoader resourceLoader;
    private final transient NamingContext namingContext;
    private final transient Map<Bean<?>, Bean<?>> specializedBeans;

    public ManagerImpl(NamingContext namingContext, EjbResolver ejbResolver, ResourceLoader resourceLoader) {
        this.ejbResolver = ejbResolver;
        this.namingContext = namingContext;
        this.resourceLoader = resourceLoader;
        this.beans = new CopyOnWriteArrayList();
        this.newEnterpriseBeanMap = new ConcurrentHashMap();
        this.enterpriseBeanMap = new ConcurrentHashMap();
        this.resolver = new Resolver(this);
        this.clientProxyProvider = new ClientProxyProvider();
        this.decorators = new HashSet<Decorator>();
        this.interceptors = new HashSet<Interceptor>();
        this.contextMap = new ContextMap();
        this.eventManager = new EventManager();
        this.ejbDescriptorCache = new EjbDescriptorCache();
        this.currentInjectionPoint = new ThreadLocal();
        this.specializedBeans = new HashMap();
        ArrayList<Class<? extends Annotation>> defaultEnabledDeploymentTypes = new ArrayList<Class<? extends Annotation>>();
        defaultEnabledDeploymentTypes.add(0, Standard.class);
        defaultEnabledDeploymentTypes.add(1, Production.class);
        this.setEnabledDeploymentTypes(defaultEnabledDeploymentTypes);
    }

    protected void checkEnabledDeploymentTypes() {
        if (!this.enabledDeploymentTypes.get(0).equals(Standard.class)) {
            throw new DeploymentException("@Standard must be the lowest precedence deployment type");
        }
    }

    public Manager addBean(Bean<?> bean) {
        if (this.beans.contains(bean)) {
            return this;
        }
        this.resolver.clear();
        this.beans.add(bean);
        return this;
    }

    public <T> Set<AnnotatedMethod<?>> resolveDisposalMethods(Class<T> apiType, Annotation ... bindings) {
        return Collections.emptySet();
    }

    public <T> Set<Observer<T>> resolveObservers(T event, Annotation ... bindings) {
        AnnotatedClass<?> element = AnnotatedClassImpl.of(event.getClass());
        for (Annotation annotation : bindings) {
            if (MetaDataCache.instance().getBindingTypeModel(annotation.annotationType()).isValid()) continue;
            throw new IllegalArgumentException("Not a binding type " + annotation);
        }
        HashSet<Annotation> bindingAnnotations = new HashSet<Annotation>(Arrays.asList(bindings));
        if (bindingAnnotations.size() < bindings.length) {
            throw new DuplicateBindingTypeException("Duplicate binding types: " + bindings);
        }
        for (Type type : element.getActualTypeArguments()) {
            if (type instanceof WildcardType) {
                throw new IllegalArgumentException("Cannot resolve an event type parameterized with a wildcard " + element);
            }
            if (!(type instanceof TypeVariable)) continue;
            throw new IllegalArgumentException("Cannot resolve an event type parameterized with a type parameter " + element);
        }
        return this.eventManager.getObservers(event, bindings);
    }

    public List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        return Collections.unmodifiableList(this.enabledDeploymentTypes);
    }

    public void setEnabledDeploymentTypes(List<Class<? extends Annotation>> enabledDeploymentTypes) {
        this.enabledDeploymentTypes = enabledDeploymentTypes;
        this.checkEnabledDeploymentTypes();
    }

    public <T> Set<Bean<T>> resolveByType(Class<T> type, Annotation ... bindings) {
        return this.resolveByType(AnnotatedClassImpl.of(type, bindings), bindings);
    }

    public <T> Set<Bean<T>> resolveByType(TypeLiteral<T> type, Annotation ... bindings) {
        return this.resolveByType(AnnotatedClassImpl.of(type, bindings), bindings);
    }

    public <T> Set<Bean<T>> resolveByType(AnnotatedItem<T, ?> element, Annotation ... bindings) {
        for (Annotation annotation : element.getAnnotationsAsSet()) {
            if (MetaDataCache.instance().getBindingTypeModel(annotation.annotationType()).isValid()) continue;
            throw new IllegalArgumentException("Not a binding type " + annotation);
        }
        for (Type type : element.getActualTypeArguments()) {
            if (type instanceof WildcardType) {
                throw new IllegalArgumentException("Cannot resolve a type parameterized with a wildcard " + element);
            }
            if (!(type instanceof TypeVariable)) continue;
            throw new IllegalArgumentException("Cannot resolve a type parameterized with a type parameter " + element);
        }
        if (bindings.length > element.getMetaAnnotations(BindingType.class).size()) {
            throw new DuplicateBindingTypeException(element.toString());
        }
        return this.resolver.get(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBeans(Set<RIBean<?>> beans) {
        Set<RIBean<?>> set = beans;
        synchronized (set) {
            this.beans = new CopyOnWriteArrayList(beans);
            for (RIBean<?> bean : beans) {
                if (bean instanceof NewEnterpriseBean) {
                    this.newEnterpriseBeanMap.put(bean.getType(), (EnterpriseBean)bean);
                    continue;
                }
                if (!(bean instanceof EnterpriseBean)) continue;
                this.enterpriseBeanMap.put(bean.getType(), (EnterpriseBean)bean);
            }
            this.resolver.clear();
        }
    }

    public Map<Class<?>, EnterpriseBean<?>> getNewEnterpriseBeanMap() {
        return this.newEnterpriseBeanMap;
    }

    public Map<Class<?>, EnterpriseBean<?>> getEnterpriseBeanMap() {
        return this.enterpriseBeanMap;
    }

    public List<Bean<?>> getBeans() {
        return Collections.unmodifiableList(this.beans);
    }

    public Manager addContext(Context context) {
        this.contextMap.add(context);
        return this;
    }

    public Manager addDecorator(Decorator decorator) {
        this.decorators.add(decorator);
        return this;
    }

    public Manager addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    public <T> Manager addObserver(Observer<T> observer, Class<T> eventType, Annotation ... bindings) {
        this.eventManager.addObserver(observer, eventType, bindings);
        return this;
    }

    public <T> Manager addObserver(ObserverImpl<T> observer) {
        this.addObserver(observer, observer.getEventType(), observer.getBindingsAsArray());
        return this;
    }

    public <T> Manager addObserver(Observer<T> observer, TypeLiteral<T> eventType, Annotation ... bindings) {
        this.eventManager.addObserver(observer, eventType.getRawType(), bindings);
        return this;
    }

    public void fireEvent(Object event, Annotation ... bindings) {
        if (Reflections.isParameterizedType(event.getClass())) {
            throw new IllegalArgumentException("Event type " + event.getClass().getName() + " is not allowed because it is a generic");
        }
        for (Annotation binding : bindings) {
            if (Reflections.isBindingType(binding)) continue;
            throw new IllegalArgumentException("Event type " + event.getClass().getName() + " cannot be fired with non-binding type " + binding.getClass().getName() + " specified");
        }
        Set observers = this.resolveObservers(event, bindings);
        this.eventManager.notifyObservers(observers, event);
    }

    public Context getContext(Class<? extends Annotation> scopeType) {
        ArrayList<Context> activeContexts = new ArrayList<Context>();
        for (Context context : this.contextMap.getContext(scopeType)) {
            if (!context.isActive()) continue;
            activeContexts.add(context);
        }
        if (activeContexts.isEmpty()) {
            throw new ContextNotActiveException("No active contexts for scope type " + scopeType.getName());
        }
        if (activeContexts.size() > 1) {
            throw new IllegalArgumentException("More than one context active for scope type " + scopeType.getName());
        }
        return (Context)activeContexts.iterator().next();
    }

    public Context getBuiltInContext(Class<? extends Annotation> scopeType) {
        return this.contextMap.getBuiltInContext(scopeType);
    }

    public <T> T getInstance(Bean<T> bean) {
        return this.getInstance(bean, true);
    }

    public <T> T getInstance(Bean<T> bean, boolean create) {
        if (create) {
            return this.getInstance(bean, new CreationalContextImpl<T>(bean));
        }
        return this.getInstance(bean, null);
    }

    private <T> T getInstance(Bean<T> bean, CreationalContextImpl<T> creationalContext) {
        if (this.specializedBeans.containsKey(bean)) {
            return (T)this.getInstance(this.specializedBeans.get(bean), creationalContext);
        }
        if (MetaDataCache.instance().getScopeModel(bean.getScopeType()).isNormal()) {
            if (creationalContext != null || creationalContext == null && this.getContext(bean.getScopeType()).get(bean) != null) {
                return this.clientProxyProvider.getClientProxy(bean);
            }
            return null;
        }
        return (T)this.getContext(bean.getScopeType()).get(bean, creationalContext);
    }

    public <T> T getInstanceToInject(InjectionPoint injectionPoint) {
        return this.getInstanceToInject(injectionPoint, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getInstanceToInject(InjectionPoint injectionPoint, CreationalContext<?> creationalContext) {
        boolean registerInjectionPoint = !injectionPoint.getType().equals(InjectionPoint.class);
        try {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.set(injectionPoint);
            }
            AnnotatedClassImpl element = AnnotatedClassImpl.of((Class)injectionPoint.getType(), injectionPoint.getBindings().toArray(new Annotation[0]));
            Bean<T> bean = this.getBeanByType(element, element.getBindingTypesAsArray());
            if (creationalContext instanceof CreationalContextImpl) {
                CreationalContextImpl ctx = (CreationalContextImpl)creationalContext;
                if (ctx.containsIncompleteInstance(bean)) {
                    T t = ctx.getIncompleteInstance(bean);
                    return t;
                }
                T t = this.getInstance(bean, ctx.getCreationalContext(bean));
                return t;
            }
            T t = this.getInstance(bean);
            return t;
        }
        finally {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.remove();
            }
        }
    }

    public Object getInstanceByName(String name) {
        Set<Bean<?>> beans = this.resolveByName(name);
        if (beans.size() == 0) {
            return null;
        }
        if (beans.size() > 1) {
            throw new AmbiguousDependencyException("Resolved multiple Web Beans with " + name);
        }
        return this.getInstance(beans.iterator().next());
    }

    public <T> T getInstanceByType(Class<T> type, Annotation ... bindings) {
        return this.getInstanceByType(AnnotatedClassImpl.of(type, bindings), bindings);
    }

    public <T> T getInstanceByType(TypeLiteral<T> type, Annotation ... bindings) {
        return this.getInstanceByType(AnnotatedClassImpl.of(type, bindings), bindings);
    }

    private <T> T getInstanceByType(AnnotatedItem<T, ?> element, Annotation ... bindings) {
        return this.getInstance(this.getBeanByType(element, bindings));
    }

    public <T> Bean<T> getBeanByType(AnnotatedItem<T, ?> element, Annotation ... bindings) {
        Set<Bean<T>> beans = this.resolveByType(element, bindings);
        if (beans.size() == 0) {
            throw new UnsatisfiedDependencyException(element + "Unable to resolve any Web Beans");
        }
        if (beans.size() > 1) {
            throw new AmbiguousDependencyException(element + "Resolved multiple Web Beans");
        }
        Bean<T> bean = beans.iterator().next();
        boolean normalScoped = MetaDataCache.instance().getScopeModel(bean.getScopeType()).isNormal();
        if (normalScoped && !Beans.isBeanProxyable(bean)) {
            throw new UnproxyableDependencyException("Normal scoped bean " + bean + " is not proxyable");
        }
        return bean;
    }

    public <T> Manager removeObserver(Observer<T> observer, Class<T> eventType, Annotation ... bindings) {
        this.eventManager.removeObserver(observer, eventType, bindings);
        return this;
    }

    public <T> Manager removeObserver(Observer<T> observer, TypeLiteral<T> eventType, Annotation ... bindings) {
        this.eventManager.removeObserver(observer, eventType.getRawType(), bindings);
        return this;
    }

    public Set<Bean<?>> resolveByName(String name) {
        return this.resolver.get(name);
    }

    public List<Decorator> resolveDecorators(Set<Type> types, Annotation ... bindings) {
        return this.resolver.resolveDecorators(types, bindings);
    }

    public List<Interceptor> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        return this.resolver.resolveInterceptors(type, interceptorBindings);
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public EjbDescriptorCache getEjbDescriptorCache() {
        return this.ejbDescriptorCache;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Manager\n");
        buffer.append("Enabled deployment types: " + this.getEnabledDeploymentTypes() + "\n");
        buffer.append("Registered contexts: " + this.contextMap.keySet() + "\n");
        buffer.append("Registered beans: " + this.getBeans().size() + "\n");
        buffer.append("Registered decorators: " + this.decorators.size() + "\n");
        buffer.append("Registered interceptors: " + this.interceptors.size() + "\n");
        return buffer.toString();
    }

    public Manager parse(InputStream xmlStream) {
        return this;
    }

    public Manager createActivity() {
        return this;
    }

    public Manager setCurrent(Class<? extends Annotation> scopeType) {
        return this;
    }

    public NamingContext getNaming() {
        return this.namingContext;
    }

    public EjbResolver getEjbResolver() {
        return this.ejbResolver;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public InjectionPoint getInjectionPoint() {
        return this.currentInjectionPoint.get();
    }

    public Map<Bean<?>, Bean<?>> getSpecializedBeans() {
        return this.specializedBeans;
    }

    protected Object readResolve() {
        return CurrentManager.rootManager();
    }
}

