/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Named;
import javax.annotation.Stereotype;
import javax.context.Dependent;
import javax.event.Event;
import javax.inject.BindingType;
import javax.inject.DefinitionException;
import javax.inject.Specializes;
import javax.inject.Standard;
import javax.inject.manager.Bean;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.context.DependentInstancesStore;
import org.jboss.webbeans.injection.AnnotatedInjectionPoint;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.literal.CurrentLiteral;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.metadata.MergedStereotypes;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBean<T, E>
extends RIBean<T> {
    private static Set<Class<?>> STANDARD_WEB_BEAN_CLASSES = new HashSet<Class>(Arrays.asList(Event.class, ManagerImpl.class));
    private boolean proxyable;
    protected DependentInstancesStore dependentInstancesStore;
    private LogProvider log = Logging.getLogProvider(AbstractBean.class);
    private Set<Annotation> bindingTypes;
    protected String name;
    protected Class<? extends Annotation> scopeType;
    private MergedStereotypes<T, E> mergedStereotypes;
    protected Class<? extends Annotation> deploymentType;
    protected Class<T> type;
    protected Set<Type> types;
    protected Set<AnnotatedInjectionPoint<?, ?>> injectionPoints;
    private boolean primitive;
    protected ManagerImpl manager;
    protected boolean _serializable;

    public static Class<? extends Annotation> getDeploymentType(List<Class<? extends Annotation>> enabledDeploymentTypes, AnnotationStore.AnnotationMap possibleDeploymentTypes) {
        for (int i = enabledDeploymentTypes.size() - 1; i > 0; --i) {
            if (!possibleDeploymentTypes.containsKey(enabledDeploymentTypes.get(i))) continue;
            return enabledDeploymentTypes.get(i);
        }
        return null;
    }

    public AbstractBean(ManagerImpl manager) {
        super(manager);
        this.manager = manager;
        this.injectionPoints = new HashSet();
        this.dependentInstancesStore = new DependentInstancesStore();
    }

    protected void init() {
        this.mergedStereotypes = new MergedStereotypes(this.getAnnotatedItem().getMetaAnnotations(Stereotype.class));
        this.initBindingTypes();
        if (this.isSpecializing()) {
            this.preCheckSpecialization();
            this.initSpecialization();
            this.postSpecialization();
        }
        this.initDefaultBindings();
        this.initType();
        this.initPrimitive();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Building Web Bean bean metadata for " + this.getType());
        }
        this.initName();
        this.initDeploymentType();
        this.checkDeploymentType();
        this.initScopeType();
        this.initTypes();
        this.initSerializable();
        this.initProxyable();
        this.checkRequiredTypesImplemented();
    }

    protected void initTypes() {
        this.types = new HashSet<Type>();
        Reflections.getTypeHierachy(this.getType(), this.types);
    }

    protected void initBindingTypes() {
        this.bindingTypes = new HashSet<Annotation>();
        this.bindingTypes.addAll(this.getAnnotatedItem().getMetaAnnotations(BindingType.class));
    }

    protected void initDefaultBindings() {
        if (this.bindingTypes.size() == 0) {
            this.log.trace("Adding default @Current binding type");
            this.bindingTypes.add((Annotation)((Object)new CurrentLiteral()));
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("Using binding types " + this.bindingTypes + " specified by annotations");
        }
    }

    protected abstract void initDeploymentType();

    protected void initDeploymentTypeFromStereotype() {
        AnnotationStore.AnnotationMap possibleDeploymentTypes = this.getMergedStereotypes().getPossibleDeploymentTypes();
        if (possibleDeploymentTypes.size() > 0) {
            this.deploymentType = AbstractBean.getDeploymentType(this.manager.getEnabledDeploymentTypes(), possibleDeploymentTypes);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Deployment type " + this.deploymentType + " specified by stereotype");
            }
            return;
        }
    }

    protected abstract Class<? extends Annotation> getDefaultDeploymentType();

    protected void initName() {
        boolean beanNameDefaulted = false;
        if (this.getAnnotatedItem().isAnnotationPresent(Named.class)) {
            String javaName = this.getAnnotatedItem().getAnnotation(Named.class).value();
            if ("".equals(javaName)) {
                this.log.trace("Using default name (specified by annotations)");
                beanNameDefaulted = true;
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Using name " + javaName + " specified by annotations");
                }
                this.name = javaName;
                return;
            }
        }
        if (beanNameDefaulted || this.getMergedStereotypes().isBeanNameDefaulted()) {
            this.name = this.getDefaultName();
            return;
        }
    }

    protected void initProxyable() {
        this.proxyable = Beans.apiTypesAreProxyable(this.getTypes());
    }

    protected void initPrimitive() {
        this.primitive = Reflections.isPrimitive(this.getType());
    }

    protected boolean checkInjectionPointsAreSerializable() {
        for (AnnotatedInjectionPoint<?, ?> injectionPoint : this.getInjectionPoints()) {
            Annotation[] bindings = injectionPoint.getMetaAnnotationsAsArray(BindingType.class);
            Bean resolvedBean = this.manager.resolveByType(injectionPoint.getType(), bindings).iterator().next();
            if (!Dependent.class.equals((Object)resolvedBean.getScopeType()) || resolvedBean.isSerializable()) continue;
            return false;
        }
        return true;
    }

    protected abstract void initScopeType();

    protected boolean initScopeTypeFromStereotype() {
        Set<Annotation> possibleScopeTypes = this.getMergedStereotypes().getPossibleScopeTypes();
        if (possibleScopeTypes.size() == 1) {
            this.scopeType = possibleScopeTypes.iterator().next().annotationType();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Scope " + this.scopeType + " specified by stereotype");
            }
            return true;
        }
        if (possibleScopeTypes.size() > 1) {
            throw new DefinitionException("All stereotypes must specify the same scope OR a scope must be specified on the bean");
        }
        return false;
    }

    protected abstract void initType();

    protected void checkDeploymentType() {
        if (this.deploymentType == null) {
            throw new DefinitionException("type: " + this.getType() + " must specify a deployment type");
        }
        if (this.deploymentType.equals(Standard.class) && !STANDARD_WEB_BEAN_CLASSES.contains(this.getAnnotatedItem().getType())) {
            throw new DefinitionException(this.getAnnotatedItem().getName() + " cannot have deployment type @Standard");
        }
    }

    protected void checkRequiredTypesImplemented() {
        for (Class<T> clazz : this.getMergedStereotypes().getRequiredTypes()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Checking if required type " + clazz + " is implemented");
            }
            if (clazz.isAssignableFrom(this.type)) continue;
            throw new DefinitionException("Required type " + clazz + " isn't implemented on " + this.type);
        }
    }

    protected void postSpecialization() {
        if (this.getAnnotatedItem().isAnnotationPresent(Named.class) && ((AbstractBean)this.getSpecializedBean()).getAnnotatedItem().isAnnotationPresent(Named.class)) {
            throw new DefinitionException("Cannot put name on specializing and specialized class");
        }
        this.bindingTypes.addAll(((AbstractBean)this.getSpecializedBean()).getBindings());
        if (this.isSpecializing() && ((AbstractBean)this.getSpecializedBean()).getAnnotatedItem().isAnnotationPresent(Named.class)) {
            this.name = ((AbstractBean)this.getSpecializedBean()).getName();
            return;
        }
        this.manager.getSpecializedBeans().put(this.getSpecializedBean(), this);
    }

    protected void preCheckSpecialization() {
    }

    protected void initSpecialization() {
    }

    protected void bindDecorators() {
    }

    protected void bindInterceptors() {
    }

    protected abstract AnnotatedItem<T, E> getAnnotatedItem();

    public Set<Annotation> getBindings() {
        return this.bindingTypes;
    }

    protected abstract String getDefaultName();

    public abstract AbstractBean<?, ?> getSpecializedBean();

    public Class<? extends Annotation> getDeploymentType() {
        return this.deploymentType;
    }

    @Override
    public Set<AnnotatedInjectionPoint<?, ?>> getInjectionPoints() {
        return this.injectionPoints;
    }

    protected MergedStereotypes<T, E> getMergedStereotypes() {
        return this.mergedStereotypes;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends Annotation> getScopeType() {
        return this.scopeType;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public boolean isAssignableFrom(AnnotatedItem<?, ?> annotatedItem) {
        return this.getAnnotatedItem().isAssignableFrom(annotatedItem);
    }

    public boolean isNullable() {
        return !this.isPrimitive();
    }

    @Override
    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isSerializable() {
        return this._serializable;
    }

    protected void initSerializable() {
        this._serializable = this.isPrimitive() || this.getTypes().contains(Serializable.class);
    }

    public String toString() {
        return "AbstractBean " + this.getName();
    }

    @Override
    public boolean isProxyable() {
        return this.proxyable;
    }

    public DependentInstancesStore getDependentInstancesStore() {
        return this.dependentInstancesStore;
    }

    @Override
    public boolean isDependent() {
        return Dependent.class.equals(this.scopeType);
    }

    @Override
    public boolean isSpecializing() {
        return this.getAnnotatedItem().isAnnotationPresent(Specializes.class);
    }

    public boolean equals(Object other) {
        if (other instanceof AbstractBean) {
            AbstractBean that = (AbstractBean)((Object)other);
            boolean equal = ((Object)this.getTypes()).equals(that.getTypes()) && ((Object)this.getBindings()).equals(that.getBindings());
            return equal;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + ((Object)this.getTypes()).hashCode();
        result = 31 * result + ((Object)this.getBindings()).hashCode();
        return result;
    }
}

