/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.context.CreationalContext;
import javax.context.Dependent;
import javax.context.ScopeType;
import javax.event.Observes;
import javax.inject.BindingType;
import javax.inject.DefinitionException;
import javax.inject.DeploymentType;
import javax.inject.Disposes;
import javax.inject.Initializer;
import javax.inject.Produces;
import javax.inject.Production;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.injection.FieldInjectionPoint;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.injection.ParameterInjectionPoint;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassBean<T>
extends AbstractBean<T, Class<T>> {
    private static final LogProvider log = Logging.getLogProvider(AbstractClassBean.class);
    protected AnnotatedClass<T> annotatedItem;
    private Set<FieldInjectionPoint<?>> injectableFields;
    private Set<MethodInjectionPoint<?>> initializerMethods;

    protected AbstractClassBean(AnnotatedClass<T> type, ManagerImpl manager) {
        super(manager);
        this.annotatedItem = type;
    }

    @Override
    protected void init() {
        super.init();
        this.checkScopeAllowed();
        this.checkBeanImplementation();
        this.initInitializerMethods();
    }

    protected void injectBoundFields(T instance, CreationalContext<T> creationalContext) {
        for (FieldInjectionPoint<T> fieldInjectionPoint : this.injectableFields) {
            fieldInjectionPoint.inject(instance, this.manager, creationalContext);
        }
    }

    protected void callInitializers(T instance, CreationalContext<T> creationalContext) {
        for (MethodInjectionPoint<T> methodInjectionPoint : this.getInitializerMethods()) {
            methodInjectionPoint.invoke(instance, this.manager, creationalContext);
        }
    }

    @Override
    protected void initType() {
        log.trace("Bean type specified in Java");
        this.type = this.getAnnotatedItem().getType();
    }

    protected void initInjectionPoints() {
        this.injectableFields = new HashSet();
        for (AnnotatedField<?> annotatedField : this.annotatedItem.getMetaAnnotatedFields(BindingType.class)) {
            if (annotatedField.isAnnotationPresent(Produces.class)) continue;
            if (annotatedField.isStatic()) {
                throw new DefinitionException("Don't place binding annotations on static fields " + annotatedField);
            }
            if (annotatedField.isFinal()) {
                throw new DefinitionException("Don't place binding annotations on final fields " + annotatedField);
            }
            FieldInjectionPoint<?> fieldInjectionPoint = FieldInjectionPoint.of(this, annotatedField);
            this.injectableFields.add(fieldInjectionPoint);
            this.injectionPoints.add(fieldInjectionPoint);
        }
        for (MethodInjectionPoint methodInjectionPoint : this.getInitializerMethods()) {
            for (AnnotatedParameter<?> parameter : methodInjectionPoint.getParameters()) {
                this.injectionPoints.add(ParameterInjectionPoint.of(this, parameter));
            }
        }
    }

    protected void initInitializerMethods() {
        this.initializerMethods = new HashSet();
        for (AnnotatedMethod<?> method : this.annotatedItem.getAnnotatedMethods(Initializer.class)) {
            if (method.isStatic()) {
                throw new DefinitionException("Initializer method " + method.toString() + " cannot be static");
            }
            if (method.getAnnotation(Produces.class) != null) {
                throw new DefinitionException("Initializer method " + method.toString() + " cannot be annotated @Produces");
            }
            if (method.getAnnotatedParameters(Disposes.class).size() > 0) {
                throw new DefinitionException("Initializer method " + method.toString() + " cannot have parameters annotated @Disposes");
            }
            if (method.getAnnotatedParameters(Observes.class).size() > 0) {
                throw new DefinitionException("Initializer method " + method.toString() + " cannot be annotated @Observes");
            }
            this.initializerMethods.add(MethodInjectionPoint.of(this, method));
        }
    }

    @Override
    protected void initScopeType() {
        for (AnnotatedClass<?> clazz = this.getAnnotatedItem(); clazz != null; clazz = clazz.getSuperclass()) {
            Set<Annotation> scopeTypes = clazz.getDeclaredMetaAnnotations(ScopeType.class);
            scopeTypes = clazz.getDeclaredMetaAnnotations(ScopeType.class);
            if (scopeTypes.size() == 1) {
                if (!this.getAnnotatedItem().isAnnotationPresent(scopeTypes.iterator().next().annotationType())) break;
                this.scopeType = scopeTypes.iterator().next().annotationType();
                log.trace("Scope " + this.scopeType + " specified by annotation");
                break;
            }
            if (scopeTypes.size() <= 1) continue;
            throw new DefinitionException("At most one scope may be specified");
        }
        if (this.scopeType == null) {
            this.initScopeTypeFromStereotype();
        }
        if (this.scopeType == null) {
            this.scopeType = Dependent.class;
            log.trace("Using default @Dependent scope");
        }
    }

    @Override
    protected void initDeploymentType() {
        for (AnnotatedClass<?> clazz = this.getAnnotatedItem(); clazz != null; clazz = clazz.getSuperclass()) {
            Set<Annotation> deploymentTypes = clazz.getDeclaredMetaAnnotations(DeploymentType.class);
            if (deploymentTypes.size() == 1) {
                if (!this.getAnnotatedItem().isAnnotationPresent(deploymentTypes.iterator().next().annotationType())) break;
                this.deploymentType = deploymentTypes.iterator().next().annotationType();
                log.trace("Deployment type " + this.deploymentType + " specified by annotation");
                break;
            }
            if (deploymentTypes.size() <= 1) continue;
            throw new DefinitionException("At most one scope may be specified");
        }
        if (this.deploymentType == null) {
            this.initDeploymentTypeFromStereotype();
        }
        if (this.deploymentType == null) {
            this.deploymentType = this.getDefaultDeploymentType();
            log.trace("Using default @Production deployment type");
            return;
        }
    }

    protected void checkScopeAllowed() {
        log.trace("Checking if " + this.getScopeType() + " is allowed for " + this.type);
        if (this.getMergedStereotypes().getSupportedScopes().size() > 0 && !this.getMergedStereotypes().getSupportedScopes().contains(this.getScopeType())) {
            throw new DefinitionException("Scope " + this.getScopeType() + " is not an allowed by the stereotype for " + this.type);
        }
    }

    protected void checkBeanImplementation() {
        if (Reflections.isAbstract(this.getType())) {
            throw new DefinitionException("Web Bean implementation class " + this.type + " cannot be declared abstract");
        }
    }

    @Override
    protected void preCheckSpecialization() {
        super.preCheckSpecialization();
        if (this.getAnnotatedItem().getSuperclass() == null || this.getAnnotatedItem().getSuperclass().getType().equals(Object.class)) {
            throw new DefinitionException("Specializing bean must extend another bean");
        }
    }

    protected AnnotatedClass<T> getAnnotatedItem() {
        return this.annotatedItem;
    }

    @Override
    protected String getDefaultName() {
        String name = Strings.decapitalize(this.getAnnotatedItem().getSimpleName());
        log.trace("Default name of " + this.type + " is " + name);
        return name;
    }

    public Set<? extends MethodInjectionPoint<?>> getInitializerMethods() {
        return this.initializerMethods;
    }

    @Override
    public String toString() {
        return "AbstractClassBean " + this.getName();
    }

    @Override
    protected Class<? extends Annotation> getDefaultDeploymentType() {
        return Production.class;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AbstractClassBean) {
            AbstractClassBean that = (AbstractClassBean)((Object)other);
            return super.equals(other) && that.getType().equals(this.getType());
        }
        return false;
    }
}

