/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.context.CreationalContext;
import javax.context.Dependent;
import javax.context.ScopeType;
import javax.inject.DefinitionException;
import javax.inject.DeploymentType;
import javax.inject.IllegalProductException;
import javax.inject.Initializer;
import javax.inject.Produces;
import javax.inject.manager.InjectionPoint;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.context.CreationalContextImpl;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.metadata.MetaDataCache;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProducerBean<T, S>
extends AbstractBean<T, S> {
    protected AbstractClassBean<?> declaringBean;
    private static final LogProvider log = Logging.getLogProvider(AbstractProducerBean.class);

    public AbstractProducerBean(AbstractClassBean<?> declaringBean, ManagerImpl manager) {
        super(manager);
        this.declaringBean = declaringBean;
    }

    @Override
    protected Class<? extends Annotation> getDefaultDeploymentType() {
        this.deploymentType = this.declaringBean.getDeploymentType();
        return this.deploymentType;
    }

    @Override
    protected void initTypes() {
        if (this.getType().isArray() || this.getType().isPrimitive()) {
            this.types = new HashSet();
            this.types.add(this.getType());
            this.types.add(Object.class);
        } else if (this.getType().isInterface()) {
            super.initTypes();
            this.types.add(Object.class);
        } else {
            super.initTypes();
        }
    }

    @Override
    protected void initType() {
        try {
            if (this.getAnnotatedItem() != null) {
                this.type = this.getAnnotatedItem().getType();
            }
        }
        catch (ClassCastException e) {
            throw new RuntimeException(" Cannot cast producer type " + this.getAnnotatedItem().getType() + " to bean type " + (this.getDeclaredBeanType() == null ? " unknown " : this.getDeclaredBeanType()), e);
        }
    }

    protected Type getDeclaredBeanType() {
        ParameterizedType parameterizedType;
        Class<?> type = ((Object)((Object)this)).getClass();
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)((Object)type)).getActualTypeArguments().length == 1) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    public AbstractClassBean<?> getDeclaringBean() {
        return this.declaringBean;
    }

    protected void checkProducerReturnType() {
        for (Type type : this.getAnnotatedItem().getActualTypeArguments()) {
            if (type instanceof Class) continue;
            throw new DefinitionException("Producer type cannot be parameterized with type parameter or wildcard:\n" + this.getAnnotatedItem());
        }
    }

    @Override
    protected void init() {
        super.init();
        this.checkProducerReturnType();
    }

    protected void checkReturnValue(T instance) {
        if (instance == null && !this.isDependent()) {
            throw new IllegalProductException("Cannot return null from a non-dependent producer method");
        }
        boolean passivating = MetaDataCache.instance().getScopeModel(this.getScopeType()).isPassivating();
        if (passivating && !Reflections.isSerializable(instance.getClass())) {
            throw new IllegalProductException("Producers cannot declare passivating scope and return a non-serializable class");
        }
        InjectionPoint injectionPoint = this.manager.getInjectionPoint();
        if (injectionPoint == null) {
            return;
        }
        if (this.isDependent() && Beans.isPassivatingBean(injectionPoint.getBean())) {
            if (injectionPoint.getMember() instanceof Field) {
                if (!Reflections.isTransient(injectionPoint.getMember()) && !Reflections.isSerializable(instance.getClass())) {
                    throw new IllegalProductException("Dependent scoped producers cannot produce non-serializable instances for injection into non-transient fields of passivating beans\n\nProducer: " + this.toString() + "\nInjection Point: " + injectionPoint.toString());
                }
            } else if (injectionPoint.getMember() instanceof Method) {
                Method method = (Method)injectionPoint.getMember();
                if (method.isAnnotationPresent(Initializer.class)) {
                    throw new IllegalProductException("Dependent scoped producers cannot produce non-serializable instances for injection into parameters of intializers of beans declaring passivating scope");
                }
                if (method.isAnnotationPresent(Produces.class)) {
                    throw new IllegalProductException("Dependent scoped producers cannot produce non-serializable instances for injection into parameters of producer methods declaring passivating scope");
                }
            } else if (injectionPoint.getMember() instanceof Constructor) {
                throw new IllegalProductException("Dependent scoped producers cannot produce non-serializable instances for injection into parameters of constructors of beans declaring passivating scope");
            }
        }
    }

    @Override
    protected void initScopeType() {
        Set<Annotation> scopeAnnotations = this.getAnnotatedItem().getMetaAnnotations(ScopeType.class);
        if (scopeAnnotations.size() > 1) {
            throw new DefinitionException("At most one scope may be specified");
        }
        if (scopeAnnotations.size() == 1) {
            this.scopeType = scopeAnnotations.iterator().next().annotationType();
            log.trace("Scope " + this.scopeType + " specified by annotation");
            return;
        }
        this.initScopeTypeFromStereotype();
        if (this.scopeType == null) {
            this.scopeType = Dependent.class;
            log.trace("Using default @Dependent scope");
        }
    }

    @Override
    protected void initDeploymentType() {
        Set<Annotation> deploymentTypes = this.getAnnotatedItem().getMetaAnnotations(DeploymentType.class);
        if (deploymentTypes.size() > 1) {
            throw new DefinitionException("At most one deployment type may be specified (" + deploymentTypes + " are specified) on " + this.getAnnotatedItem().toString());
        }
        if (deploymentTypes.size() == 1) {
            this.deploymentType = deploymentTypes.iterator().next().annotationType();
            log.trace("Deployment type " + this.deploymentType + " specified by annotation");
            return;
        }
        this.initDeploymentTypeFromStereotype();
        if (this.deploymentType == null) {
            this.deploymentType = this.getDefaultDeploymentType();
            log.trace("Using default " + this.deploymentType + " deployment type");
            return;
        }
    }

    @Override
    protected void initSerializable() {
        this._serializable = true;
    }

    protected Object getReceiver(CreationalContext<?> creationalContext) {
        CreationalContextImpl creationalContextImpl;
        if (creationalContext instanceof CreationalContextImpl && (creationalContextImpl = (CreationalContextImpl)creationalContext).containsIncompleteInstance(this.getDeclaringBean())) {
            log.warn("Executing producer method on incomplete declaring bean due to circular injection");
            return creationalContextImpl.getIncompleteInstance(this.getDeclaringBean());
        }
        return this.getAnnotatedItem().isStatic() ? null : this.manager.getInstance(this.getDeclaringBean());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T create(CreationalContext<T> creationalContext) {
        Object dependentCollector = new Object();
        try {
            if (this.getDeclaringBean().isDependent()) {
                DependentContext.INSTANCE.setCurrentInjectionInstance(dependentCollector);
            }
            DependentContext.INSTANCE.setActive(true);
            T instance = this.produceInstance(creationalContext);
            this.checkReturnValue(instance);
            T t = instance;
            return t;
        }
        finally {
            if (this.getDeclaringBean().isDependent()) {
                DependentContext.INSTANCE.clearCurrentInjectionInstance(dependentCollector);
                this.dependentInstancesStore.destroyDependentInstances(dependentCollector);
            }
            DependentContext.INSTANCE.setActive(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(T instance) {
        try {
            DependentContext.INSTANCE.setActive(true);
        }
        finally {
            DependentContext.INSTANCE.setActive(false);
        }
    }

    protected abstract T produceInstance(CreationalContext<T> var1);

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Annotated " + Names.scopeTypeToString(this.getScopeType()));
        if (this.getName() == null) {
            buffer.append("unnamed producer bean");
        } else {
            buffer.append("simple producer bean '" + this.getName() + "'");
        }
        buffer.append(" [" + this.getType().getName() + "]\n");
        buffer.append("   API types " + this.getTypes() + ", binding types " + this.getBindings() + "\n");
        return buffer.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AbstractProducerBean) {
            AbstractProducerBean that = (AbstractProducerBean)((Object)other);
            return super.equals(other) && this.getDeclaringBean().equals(that.getDeclaringBean());
        }
        return false;
    }
}

