/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.context.ApplicationScoped;
import javax.context.CreationalContext;
import javax.context.Dependent;
import javax.decorator.Decorator;
import javax.event.Observes;
import javax.inject.CreationException;
import javax.inject.DefinitionException;
import javax.interceptor.Interceptor;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.proxy.EnterpriseBeanInstance;
import org.jboss.webbeans.bean.proxy.EnterpriseBeanProxyMethodHandler;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.ejb.InternalEjbDescriptor;
import org.jboss.webbeans.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.jlr.AnnotatedClassImpl;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.util.Proxies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseBean<T>
extends AbstractClassBean<T> {
    private LogProvider log = Logging.getLogProvider(EnterpriseBean.class);
    private InternalEjbDescriptor<T> ejbDescriptor;
    private Class<T> proxyClass;
    private EnterpriseBean<?> specializedBean;

    public static <T> EnterpriseBean<T> of(Class<T> clazz, ManagerImpl manager) {
        return EnterpriseBean.of(AnnotatedClassImpl.of(clazz), manager);
    }

    public static <T> EnterpriseBean<T> of(AnnotatedClass<T> clazz, ManagerImpl manager) {
        return new EnterpriseBean<T>(clazz, manager);
    }

    protected EnterpriseBean(AnnotatedClass<T> type, ManagerImpl manager) {
        super(type, manager);
        this.init();
    }

    @Override
    protected void init() {
        this.initType();
        Iterable ejbDescriptors = this.manager.getEjbDescriptorCache().get(this.getType());
        if (ejbDescriptors == null) {
            throw new DefinitionException("Not an EJB " + this.toString());
        }
        for (InternalEjbDescriptor ejbDescriptor : ejbDescriptors) {
            if (this.ejbDescriptor == null) {
                this.ejbDescriptor = ejbDescriptor;
                continue;
            }
            throw new RuntimeException("TODO Multiple EJBs have the same bean class! " + this.getType());
        }
        super.init();
        this.initProxyClass();
        this.initInjectionPoints();
        this.checkEnterpriseBeanTypeAllowed();
        this.checkEnterpriseScopeAllowed();
        this.checkConflictingRoles();
        this.checkObserverMethods();
    }

    @Override
    protected void initTypes() {
        this.types = new LinkedHashSet();
        this.types.add(Object.class);
        for (BusinessInterfaceDescriptor<?> businessInterfaceDescriptor : this.ejbDescriptor.getLocalBusinessInterfaces()) {
            this.types.add(businessInterfaceDescriptor.getInterface());
        }
    }

    protected void initProxyClass() {
        Class proxyClass;
        LinkedHashSet<Type> types = new LinkedHashSet<Type>(this.getTypes());
        types.add((Type)((Object)EnterpriseBeanInstance.class));
        ProxyFactory proxyFactory = Proxies.getProxyFactory(types);
        this.proxyClass = proxyClass = proxyFactory.createClass();
    }

    protected void checkConflictingRoles() {
        if (this.getType().isAnnotationPresent(Interceptor.class)) {
            throw new DefinitionException("Enterprise beans cannot be interceptors");
        }
        if (this.getType().isAnnotationPresent(Decorator.class)) {
            throw new DefinitionException("Enterprise beans cannot be decorators");
        }
    }

    protected void checkEnterpriseScopeAllowed() {
        if (this.ejbDescriptor.isStateless() && !this.getScopeType().equals(Dependent.class)) {
            throw new DefinitionException("Scope " + this.getScopeType() + " is not allowed on stateless enterpise beans for " + this.getType() + ". Only @Dependent is allowed on stateless enterprise beans");
        }
        if (this.ejbDescriptor.isSingleton() && !this.getScopeType().equals(Dependent.class) && !this.getScopeType().equals(ApplicationScoped.class)) {
            throw new DefinitionException("Scope " + this.getScopeType() + " is not allowed on singleton enterpise beans for " + this.getType() + ". Only @Dependent or @ApplicationScoped is allowed on singleton enterprise beans");
        }
    }

    @Override
    protected void preCheckSpecialization() {
        super.preCheckSpecialization();
        if (!this.manager.getEjbDescriptorCache().containsKey(this.getAnnotatedItem().getSuperclass().getType())) {
            throw new DefinitionException("Annotation defined specializing EJB must have EJB superclass");
        }
    }

    @Override
    protected void initSpecialization() {
        this.specializedBean = EnterpriseBean.of(this.getAnnotatedItem().getSuperclass(), this.manager);
    }

    public T create(CreationalContext<T> creationalContext) {
        try {
            DependentContext.INSTANCE.setActive(true);
            T instance = this.proxyClass.newInstance();
            creationalContext.push(instance);
            ((ProxyObject)instance).setHandler((MethodHandler)new EnterpriseBeanProxyMethodHandler(this, this.ejbDescriptor.getRemoveMethods()));
            if (this.log.isTraceEnabled()) {
                this.log.trace("Enterprise bean instance created for bean " + (Object)((Object)this));
            }
            T t = instance;
            return t;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not instantiate enterprise proxy for " + this.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not access bean correctly when creating enterprise proxy for " + this.toString(), e);
        }
        catch (Exception e) {
            throw new CreationException("could not find the EJB in JNDI " + this.proxyClass, (Throwable)e);
        }
        finally {
            DependentContext.INSTANCE.setActive(false);
        }
    }

    public void destroy(T instance) {
        EnterpriseBeanInstance enterpiseBeanInstance = (EnterpriseBeanInstance)instance;
        if (enterpiseBeanInstance.isDestroyed()) {
            return;
        }
    }

    protected void injectEjbAndCommonFields() {
    }

    private void checkEnterpriseBeanTypeAllowed() {
        if (this.ejbDescriptor.isMessageDriven()) {
            throw new DefinitionException("Message Driven Beans can't be Web Beans");
        }
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.getName() == null) {
            buffer.append(" unnamed enterprise bean");
        } else {
            buffer.append(" enterprise bean '" + this.getName() + "'");
        }
        buffer.append(" [" + this.getType().getName() + "]\n");
        buffer.append("   API types " + this.getTypes() + ", binding types " + this.getBindings() + "\n");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConstruct(T instance) {
        try {
            CreationalContext creationalContext = new CreationalContext<T>(){

                public void push(T incompleteInstance) {
                }
            };
            DependentContext.INSTANCE.setCurrentInjectionInstance(instance);
            DependentContext.INSTANCE.setActive(true);
            this.bindDecorators();
            this.bindInterceptors();
            this.injectEjbAndCommonFields();
            this.injectBoundFields(instance, creationalContext);
            this.callInitializers(instance, creationalContext);
        }
        finally {
            DependentContext.INSTANCE.clearCurrentInjectionInstance(instance);
            DependentContext.INSTANCE.setActive(false);
        }
    }

    public void preDestroy(T instance) {
    }

    @Override
    public boolean isSerializable() {
        return this.checkInjectionPointsAreSerializable();
    }

    public InternalEjbDescriptor<T> getEjbDescriptor() {
        return this.ejbDescriptor;
    }

    public boolean canCallRemoveMethods() {
        return this.getEjbDescriptor().isStateful() && this.isDependent();
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return this.specializedBean;
    }

    protected void checkObserverMethods() {
        for (AnnotatedMethod<?> method : this.annotatedItem.getDeclaredMethodsWithAnnotatedParameters(Observes.class)) {
            if (method.isStatic() || this.getTypes().contains(((Method)method.getMember()).getDeclaringClass())) continue;
            throw new DefinitionException("Observer method must be static or business method: " + method);
        }
    }
}

