/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import javax.context.CreationalContext;
import javax.event.Observes;
import javax.inject.DefinitionException;
import javax.inject.Disposes;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.AbstractProducerBean;
import org.jboss.webbeans.bean.SimpleBean;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.injection.ParameterInjectionPoint;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.jlr.AnnotatedMethodImpl;
import org.jboss.webbeans.metadata.MetaDataCache;
import org.jboss.webbeans.util.Names;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerMethodBean<T>
extends AbstractProducerBean<T, Method> {
    private MethodInjectionPoint<T> method;
    private AnnotatedMethod<?> disposalMethod;
    private ProducerMethodBean<?> specializedBean;

    public static <T> ProducerMethodBean<T> of(AnnotatedMethod<T> method, AbstractClassBean<?> declaringBean, ManagerImpl manager) {
        return new ProducerMethodBean<T>(method, declaringBean, manager);
    }

    public static <T> ProducerMethodBean<T> of(Method method, AbstractClassBean<?> declaringBean, ManagerImpl manager) {
        return ProducerMethodBean.of(AnnotatedMethodImpl.of(method, declaringBean.getAnnotatedItem()), declaringBean, manager);
    }

    protected ProducerMethodBean(AnnotatedMethod<T> method, AbstractClassBean<?> declaringBean, ManagerImpl manager) {
        super(declaringBean, manager);
        this.method = MethodInjectionPoint.of(this, method);
        this.init();
    }

    @Override
    protected T produceInstance(CreationalContext<T> creationalContext) {
        return this.method.invoke(this.getReceiver(creationalContext), this.manager, creationalContext);
    }

    @Override
    protected void init() {
        super.init();
        this.checkProducerMethod();
        this.initDisposalMethod();
        this.initInjectionPoints();
    }

    protected void initInjectionPoints() {
        for (ParameterInjectionPoint<?> parameter : this.method.getParameters()) {
            this.injectionPoints.add(ParameterInjectionPoint.of(this, parameter));
        }
    }

    protected void checkProducerMethod() {
        if (this.getAnnotatedItem().getAnnotatedParameters(Observes.class).size() > 0) {
            throw new DefinitionException("Producer method cannot have parameter annotated @Observes");
        }
        if (this.getAnnotatedItem().getAnnotatedParameters(Disposes.class).size() > 0) {
            throw new DefinitionException("Producer method cannot have parameter annotated @Disposes");
        }
    }

    protected void initDisposalMethod() {
        Set<AnnotatedMethod<?>> disposalMethods = this.manager.resolveDisposalMethods(this.getType(), this.getBindings().toArray(new Annotation[0]));
        if (disposalMethods.size() == 1) {
            this.disposalMethod = disposalMethods.iterator().next();
        } else if (disposalMethods.size() > 1) {
            throw new DefinitionException("Cannot declare multiple disposal methods for this producer method");
        }
    }

    protected AnnotatedMethod<T> getAnnotatedItem() {
        return this.method;
    }

    @Override
    protected String getDefaultName() {
        return this.method.getPropertyName();
    }

    public AnnotatedMethod<?> getDisposalMethod() {
        return this.disposalMethod;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Annotated " + Names.scopeTypeToString(this.getScopeType()));
        if (this.getName() == null) {
            buffer.append("unnamed producer method bean");
        } else {
            buffer.append("simple producer method bean '" + this.getName() + "'");
        }
        buffer.append(" [" + this.getType().getName() + "]\n");
        buffer.append("   API types " + this.getTypes() + ", binding types " + this.getBindings() + "\n");
        return buffer.toString();
    }

    @Override
    public boolean isSerializable() {
        boolean passivatingScoped = MetaDataCache.instance().getScopeModel(this.scopeType).isPassivating();
        if (passivatingScoped) {
            return this.checkInjectionPointsAreSerializable();
        }
        return true;
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return this.specializedBean;
    }

    @Override
    protected void preCheckSpecialization() {
        if (this.declaringBean.getAnnotatedItem().getSuperclass().getDeclaredMethod(this.getAnnotatedItem().getAnnotatedMethod()) == null) {
            throw new DefinitionException("Specialized producer method does not override a method on the direct superclass");
        }
    }

    @Override
    protected void initSpecialization() {
        this.specializedBean = ProducerMethodBean.of(this.declaringBean.getAnnotatedItem().getSuperclass().getMethod(this.getAnnotatedItem().getAnnotatedMethod()), SimpleBean.of(this.declaringBean.getAnnotatedItem().getSuperclass(), this.manager), this.manager);
    }
}

