/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.context.CreationalContext;
import javax.context.Dependent;
import javax.inject.DefinitionException;
import javax.inject.Initializer;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.injection.AnnotatedInjectionPoint;
import org.jboss.webbeans.injection.ConstructorInjectionPoint;
import org.jboss.webbeans.injection.FieldInjectionPoint;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.injection.ParameterInjectionPoint;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedConstructor;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.jlr.AnnotatedClassImpl;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.metadata.MetaDataCache;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBean<T>
extends AbstractClassBean<T> {
    private static LogProvider log = Logging.getLogProvider(SimpleBean.class);
    private static List<Class<?>> NO_ARGUMENTS = Collections.emptyList();
    private ConstructorInjectionPoint<T> constructor;
    private AnnotatedMethod<?> postConstruct;
    private AnnotatedMethod<?> preDestroy;
    private Set<AnnotatedInjectionPoint<?, ?>> ejbInjectionPoints;
    private Set<AnnotatedInjectionPoint<?, ?>> persistenceUnitInjectionPoints;
    private Set<AnnotatedInjectionPoint<?, ?>> resourceInjectionPoints;
    private SimpleBean<?> specializedBean;

    public static <T> SimpleBean<T> of(Class<T> clazz, ManagerImpl manager) {
        return SimpleBean.of(AnnotatedClassImpl.of(clazz), manager);
    }

    public static <T> SimpleBean<T> of(AnnotatedClass<T> clazz, ManagerImpl manager) {
        return new SimpleBean<T>(clazz, manager);
    }

    protected SimpleBean(AnnotatedClass<T> type, ManagerImpl manager) {
        super(type, manager);
        this.init();
    }

    /*
     * Exception decompiling
     */
    public T create(CreationalContext<T> creationalContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.getBindingFor(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "res" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.getGtbNullFiltered(GenericInferer.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.inferGenericObjectInfoFromCalls(GenericInferer.java:139)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:484)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(T instance) {
        try {
            DependentContext.INSTANCE.setActive(true);
            this.callPreDestroy(instance);
            this.dependentInstancesStore.destroyDependentInstances(instance);
        }
        catch (Exception e) {
            log.error("Error destroying " + this.toString(), e);
        }
        finally {
            DependentContext.INSTANCE.setActive(false);
        }
    }

    protected void callPreDestroy(T instance) {
        AnnotatedMethod<?> preDestroy = this.getPreDestroy();
        if (preDestroy != null) {
            try {
                preDestroy.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke " + preDestroy + " on " + instance, e);
            }
        }
    }

    protected void callPostConstruct(T instance) {
        AnnotatedMethod<?> postConstruct = this.getPostConstruct();
        if (postConstruct != null) {
            try {
                postConstruct.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke " + postConstruct + " on " + instance, e);
            }
        }
    }

    protected void initEjbInjectionPoints() {
        this.ejbInjectionPoints = new HashSet();
        for (AnnotatedField<?> annotatedField : this.annotatedItem.getAnnotatedFields(this.manager.getEjbResolver().getEJBAnnotation())) {
            this.ejbInjectionPoints.add(FieldInjectionPoint.of(this, annotatedField));
        }
        for (AnnotatedMethod annotatedMethod : this.annotatedItem.getAnnotatedMethods(this.manager.getEjbResolver().getEJBAnnotation())) {
            this.ejbInjectionPoints.add(MethodInjectionPoint.of(this, annotatedMethod));
        }
    }

    protected void initPersistenceUnitInjectionPoints() {
        this.persistenceUnitInjectionPoints = new HashSet();
        for (AnnotatedField<?> annotatedField : this.annotatedItem.getAnnotatedFields(this.manager.getEjbResolver().getPersistenceContextAnnotation())) {
            if (annotatedField.getAnnotation(PersistenceContext.class).type().equals((Object)PersistenceContextType.EXTENDED)) {
                throw new DefinitionException("Cannot inject an extended persistence context into " + annotatedField);
            }
            this.persistenceUnitInjectionPoints.add(FieldInjectionPoint.of(this, annotatedField));
        }
        for (AnnotatedMethod annotatedMethod : this.annotatedItem.getAnnotatedMethods(this.manager.getEjbResolver().getPersistenceContextAnnotation())) {
            if (annotatedMethod.getAnnotation(PersistenceContext.class).type().equals((Object)PersistenceContextType.EXTENDED)) {
                throw new DefinitionException("Cannot inject an extended persistence context into " + annotatedMethod);
            }
            this.persistenceUnitInjectionPoints.add(MethodInjectionPoint.of(this, annotatedMethod));
        }
    }

    protected void initResourceInjectionPoints() {
        this.resourceInjectionPoints = new HashSet();
        for (AnnotatedField<?> field : this.annotatedItem.getAnnotatedFields(this.manager.getEjbResolver().getResourceAnnotation())) {
            this.resourceInjectionPoints.add(FieldInjectionPoint.of(this, field));
        }
    }

    protected void injectEjbAndCommonFields(T beanInstance) {
        for (AnnotatedInjectionPoint<?, ?> injectionPoint : this.ejbInjectionPoints) {
            Object ejbInstance = this.manager.getEjbResolver().resolveEjb(injectionPoint, this.manager.getNaming());
            injectionPoint.inject(beanInstance, ejbInstance);
        }
        for (AnnotatedInjectionPoint<?, ?> injectionPoint : this.persistenceUnitInjectionPoints) {
            Object puInstance = this.manager.getEjbResolver().resolvePersistenceContext(injectionPoint, this.manager.getNaming());
            injectionPoint.inject(beanInstance, puInstance);
        }
        for (AnnotatedInjectionPoint<?, ?> injectionPoint : this.resourceInjectionPoints) {
            Object resourceInstance = this.manager.getEjbResolver().resolveResource(injectionPoint, this.manager.getNaming());
            injectionPoint.inject(beanInstance, resourceInstance);
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initConstructor();
        this.checkType();
        this.initInjectionPoints();
        this.initPostConstruct();
        this.initPreDestroy();
        this.initEjbInjectionPoints();
        this.initPersistenceUnitInjectionPoints();
        this.initResourceInjectionPoints();
    }

    @Override
    protected void initInjectionPoints() {
        super.initInjectionPoints();
        for (ParameterInjectionPoint<?> parameter : this.constructor.getParameters()) {
            this.injectionPoints.add(ParameterInjectionPoint.of(this, parameter));
        }
    }

    protected void checkType() {
        if (this.getAnnotatedItem().isNonStaticMemberClass()) {
            throw new DefinitionException("Simple Web Bean " + this.type + " cannot be a non-static inner class");
        }
        if (this.getAnnotatedItem().isParameterizedType()) {
            throw new DefinitionException("Simple Web Bean " + this.type + " cannot be a parameterized type");
        }
        boolean passivating = MetaDataCache.instance().getScopeModel(this.scopeType).isPassivating();
        if (passivating && !Reflections.isSerializable(this.type)) {
            throw new DefinitionException("Simple Web Beans declaring a passivating scope must have a serializable implementation class");
        }
    }

    @Override
    protected void checkBeanImplementation() {
        super.checkBeanImplementation();
        if (!this.scopeType.equals(Dependent.class)) {
            for (AnnotatedField<?> field : this.getAnnotatedItem().getFields()) {
                if (!field.isPublic() || field.isStatic()) continue;
                throw new DefinitionException("Normal scoped Web Bean implementation class has a public field " + this.getAnnotatedItem());
            }
        }
    }

    @Override
    protected void preCheckSpecialization() {
        super.preCheckSpecialization();
        if (this.manager.getEjbDescriptorCache().containsKey(this.getAnnotatedItem().getSuperclass().getType())) {
            throw new DefinitionException("Simple bean must specialize a simple bean");
        }
    }

    @Override
    protected void initSpecialization() {
        this.specializedBean = SimpleBean.of(this.getAnnotatedItem().getSuperclass(), this.manager);
    }

    protected void initConstructor() {
        Set initializerAnnotatedConstructors = this.getAnnotatedItem().getAnnotatedConstructors(Initializer.class);
        log.trace("Found " + initializerAnnotatedConstructors + " constructors annotated with @Initializer for " + this.getType());
        if (initializerAnnotatedConstructors.size() > 1) {
            if (initializerAnnotatedConstructors.size() > 1) {
                throw new DefinitionException("Cannot have more than one constructor annotated with @Initializer for " + this.getType());
            }
        } else if (initializerAnnotatedConstructors.size() == 1) {
            this.constructor = ConstructorInjectionPoint.of(this, initializerAnnotatedConstructors.iterator().next());
            log.trace("Exactly one constructor (" + this.constructor + ") annotated with @Initializer defined, using it as the bean constructor for " + this.getType());
            return;
        }
        if (this.getAnnotatedItem().getConstructor(NO_ARGUMENTS) != null) {
            this.constructor = ConstructorInjectionPoint.of(this, this.getAnnotatedItem().getConstructor(NO_ARGUMENTS));
            log.trace("Exactly one constructor (" + this.constructor + ") defined, using it as the bean constructor for " + this.getType());
            return;
        }
        throw new DefinitionException("Cannot determine constructor to use for " + this.getType());
    }

    protected void initPostConstruct() {
        Set<AnnotatedMethod<?>> postConstructMethods = this.getAnnotatedItem().getAnnotatedMethods(PostConstruct.class);
        log.trace("Found " + postConstructMethods + " constructors annotated with @Initializer for " + this.getType());
        if (postConstructMethods.size() > 1) {
            throw new DefinitionException("Cannot have more than one post construct method annotated with @PostConstruct for " + this.getType());
        }
        if (postConstructMethods.size() == 1) {
            this.postConstruct = postConstructMethods.iterator().next();
            log.trace("Exactly one post construct method (" + this.postConstruct + ") for " + this.getType());
            return;
        }
    }

    protected void initPreDestroy() {
        Set<AnnotatedMethod<?>> preDestroyMethods = this.getAnnotatedItem().getAnnotatedMethods(PreDestroy.class);
        log.trace("Found " + preDestroyMethods + " constructors annotated with @Initializer for " + this.getType());
        if (preDestroyMethods.size() > 1) {
            throw new DefinitionException("Cannot have more than one pre destroy method annotated with @PreDestroy for " + this.getType());
        }
        if (preDestroyMethods.size() == 1) {
            this.preDestroy = preDestroyMethods.iterator().next();
            log.trace("Exactly one post construct method (" + this.preDestroy + ") for " + this.getType());
            return;
        }
    }

    @Override
    protected void initType() {
        log.trace("Bean type specified in Java");
        this.type = this.getAnnotatedItem().getType();
    }

    public AnnotatedConstructor<T> getConstructor() {
        return this.constructor;
    }

    public AnnotatedMethod<?> getPostConstruct() {
        return this.postConstruct;
    }

    public AnnotatedMethod<?> getPreDestroy() {
        return this.preDestroy;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Names.scopeTypeToString(this.getScopeType()));
        if (this.getName() == null) {
            buffer.append("unnamed simple bean");
        } else {
            buffer.append("simple bean '" + this.getName() + "'");
        }
        buffer.append(" ").append(this.getType().getName()).append(", ");
        buffer.append(" API types = ").append(Names.typesToString(this.getTypes())).append(", binding types = " + Names.annotationsToString(this.getBindings()));
        return buffer.toString();
    }

    @Override
    public boolean isSerializable() {
        if (this.isDependent()) {
            return Reflections.isSerializable(this.getType());
        }
        return this.checkInjectionPointsAreSerializable();
    }

    @Override
    public SimpleBean<?> getSpecializedBean() {
        return this.specializedBean;
    }
}

