/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean.proxy;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseBeanProxyMethodHandler
implements MethodHandler {
    private static final transient LogProvider log = Logging.getLogProvider(EnterpriseBeanProxyMethodHandler.class);
    private static final ThreadLocal<Set<Class<?>>> contextualInstance = new ThreadLocal<Set<Class<?>>>(){

        @Override
        protected Set<Class<?>> initialValue() {
            return new HashSet();
        }
    };
    private final Map<Class<?>, Object> proxiedInstances = new HashMap();
    private final Map<Class<?>, String> jndiNames;
    private boolean destroyed;
    private boolean canCallRemoveMethods;
    private final List<Method> removeMethods;
    private final Class<?> beanClass;

    public static boolean isContextualInstance(Class<?> beanClass) {
        return contextualInstance.get().contains(beanClass);
    }

    private static void setContextualInstance(Class<?> beanClass, boolean accessing) {
        if (accessing) {
            contextualInstance.get().add(beanClass);
        } else {
            contextualInstance.get().remove(beanClass);
        }
    }

    public EnterpriseBeanProxyMethodHandler(EnterpriseBean<?> bean, Iterable<Method> removeMethods) {
        this.jndiNames = bean.getEjbDescriptor().getLocalBusinessInterfacesJndiNames();
        this.canCallRemoveMethods = bean.canCallRemoveMethods();
        this.removeMethods = bean.getEjbDescriptor().getRemoveMethods();
        this.destroyed = false;
        this.beanClass = bean.getType();
        log.trace("Created enterprise bean proxy method handler for " + bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
        Method proxiedMethod;
        if ("isDestroyed".equals(method.getName())) {
            return this.destroyed;
        }
        Class<?> businessInterface = method.getDeclaringClass();
        Object proxiedInstance = this.proxiedInstances.get(businessInterface);
        if (proxiedInstance == null) {
            String jndiName = this.jndiNames.get(businessInterface);
            if (jndiName == null) {
                throw new IllegalStateException("Unable to establish jndi name to use to lookup EJB");
            }
            try {
                EnterpriseBeanProxyMethodHandler.setContextualInstance(this.beanClass, true);
                proxiedInstance = CurrentManager.rootManager().getNaming().lookup(jndiName, businessInterface);
            }
            finally {
                EnterpriseBeanProxyMethodHandler.setContextualInstance(this.beanClass, false);
            }
            this.proxiedInstances.put(businessInterface, proxiedInstance);
        }
        if (this.removeMethods.contains(proxiedMethod = Reflections.lookupMethod(method, proxiedInstance))) {
            if (this.canCallRemoveMethods) {
                this.destroyed = true;
            } else {
                throw new UnsupportedOperationException("Remove method can't be called directly on non-dependent scoped Enterprise Beans");
            }
        }
        try {
            EnterpriseBeanProxyMethodHandler.setContextualInstance(this.beanClass, true);
            Object returnValue = Reflections.invokeAndWrap(proxiedMethod, proxiedInstance, args);
            log.trace("Executed " + method + " on " + proxiedInstance + " with parameters " + args + " and got return value " + returnValue);
            Object object = returnValue;
            return object;
        }
        finally {
            EnterpriseBeanProxyMethodHandler.setContextualInstance(this.beanClass, false);
        }
    }
}

