/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.event.Fires;
import javax.event.Observes;
import javax.inject.BindingType;
import javax.inject.DeploymentType;
import javax.inject.Initializer;
import javax.inject.Obtains;
import javax.inject.Produces;
import javax.inject.Realizes;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.bean.EventBean;
import org.jboss.webbeans.bean.InstanceBean;
import org.jboss.webbeans.bean.NewEnterpriseBean;
import org.jboss.webbeans.bean.NewSimpleBean;
import org.jboss.webbeans.bean.ProducerFieldBean;
import org.jboss.webbeans.bean.ProducerMethodBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.bean.SimpleBean;
import org.jboss.webbeans.ejb.EJBApiAbstraction;
import org.jboss.webbeans.event.ObserverImpl;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.WrappedAnnotatedField;
import org.jboss.webbeans.introspector.WrappedAnnotatedMethod;
import org.jboss.webbeans.introspector.jlr.AnnotatedClassImpl;
import org.jboss.webbeans.jsf.JSFApiAbstraction;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.servlet.ServletApiAbstraction;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeployer {
    private static final LogProvider log = Logging.getLogProvider(BeanDeployer.class);
    private static final Set<Annotation> EMPTY_BINDINGS = Collections.emptySet();
    private final Set<RIBean<?>> beans;
    private final Set<AnnotatedClass<?>> deferredClasses;
    private final ManagerImpl manager;

    public BeanDeployer(ManagerImpl manager) {
        this.manager = manager;
        this.beans = new HashSet();
        this.deferredClasses = new HashSet();
    }

    public void addBean(RIBean<?> bean) {
        this.beans.add(bean);
    }

    public void addClass(Class<?> clazz) {
        this.deferredClasses.add(AnnotatedClassImpl.of(clazz));
    }

    public void addClasses(Iterable<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            this.addClass(clazz);
        }
    }

    public void deploy() {
        for (AnnotatedClass<?> clazz : this.deferredClasses) {
            if (this.manager.getEjbDescriptorCache().containsKey(clazz.getType())) {
                this.createEnterpriseBean(clazz);
                continue;
            }
            if (!this.isTypeSimpleWebBean(clazz.getType())) continue;
            this.createSimpleBean(clazz);
        }
        this.manager.setBeans(this.beans);
    }

    protected void createBean(AbstractClassBean<?> bean, AnnotatedClass<?> annotatedClass) {
        this.beans.add(bean);
        this.manager.getResolver().addInjectionPoints(bean.getInjectionPoints());
        this.createProducerMethods(bean, annotatedClass);
        this.createProducerFields(bean, annotatedClass);
        this.createObserverMethods(bean, annotatedClass);
        this.createFacades(bean.getInjectionPoints());
        if (annotatedClass.isAnnotationPresent(Realizes.class)) {
            this.createRealizedProducerMethods(bean, annotatedClass);
            this.createRealizedProducerFields(bean, annotatedClass);
            this.createRealizedObserverMethods(bean, annotatedClass);
        }
        log.info("Web Bean: " + bean);
    }

    private void createProducerMethods(AbstractClassBean<?> declaringBean, AnnotatedClass<?> annotatedClass) {
        for (AnnotatedMethod<?> method : annotatedClass.getDeclaredAnnotatedMethods(Produces.class)) {
            this.createProducerMethod(declaringBean, method);
        }
    }

    private void createProducerMethod(AbstractClassBean<?> declaringBean, AnnotatedMethod<?> annotatedMethod) {
        ProducerMethodBean<?> bean = ProducerMethodBean.of(annotatedMethod, declaringBean, this.manager);
        this.beans.add(bean);
        this.manager.getResolver().addInjectionPoints(bean.getInjectionPoints());
        this.createFacades(bean.getInjectionPoints());
        log.info("Web Bean: " + bean);
    }

    private void createRealizedProducerMethods(AbstractClassBean<?> declaringBean, AnnotatedClass<?> realizingClass) {
        AnnotatedClass<?> realizedClass = realizingClass.getSuperclass();
        for (AnnotatedMethod<?> realizedMethod : realizedClass.getDeclaredAnnotatedMethods(Produces.class)) {
            this.createProducerMethod(declaringBean, BeanDeployer.realizeProducerMethod(realizedMethod, realizingClass));
        }
    }

    private void createRealizedProducerFields(AbstractClassBean<?> declaringBean, AnnotatedClass<?> realizingClass) {
        AnnotatedClass<?> realizedClass = realizingClass.getSuperclass();
        for (AnnotatedField<?> realizedField : realizedClass.getDeclaredAnnotatedFields(Produces.class)) {
            this.createProducerField(declaringBean, BeanDeployer.realizeProducerField(realizedField, realizingClass));
        }
    }

    private void createProducerField(AbstractClassBean<?> declaringBean, AnnotatedField<?> field) {
        ProducerFieldBean<?> bean = ProducerFieldBean.of(field, declaringBean, this.manager);
        this.beans.add(bean);
        log.info("Web Bean: " + bean);
    }

    private void createProducerFields(AbstractClassBean<?> declaringBean, AnnotatedClass<?> annotatedClass) {
        for (AnnotatedField<?> field : annotatedClass.getDeclaredAnnotatedFields(Produces.class)) {
            this.createProducerField(declaringBean, field);
        }
    }

    private void createObserverMethods(AbstractClassBean<?> declaringBean, AnnotatedClass<?> annotatedClass) {
        for (AnnotatedMethod<?> method : annotatedClass.getDeclaredMethodsWithAnnotatedParameters(Observes.class)) {
            this.createObserverMethod(declaringBean, method);
        }
    }

    private void createRealizedObserverMethods(AbstractClassBean<?> declaringBean, AnnotatedClass<?> realizingClass) {
        this.createObserverMethods(declaringBean, realizingClass.getSuperclass());
    }

    private void createObserverMethod(AbstractClassBean<?> declaringBean, AnnotatedMethod<?> method) {
        ObserverImpl observer = ObserverImpl.of(method, declaringBean, this.manager);
        this.manager.addObserver(observer);
    }

    private void createSimpleBean(AnnotatedClass<?> annotatedClass) {
        SimpleBean<?> bean = SimpleBean.of(annotatedClass, this.manager);
        this.createBean(bean, annotatedClass);
        this.beans.add(NewSimpleBean.of(annotatedClass, this.manager));
    }

    private void createEnterpriseBean(AnnotatedClass<?> annotatedClass) {
        EnterpriseBean<?> bean = EnterpriseBean.of(annotatedClass, this.manager);
        this.createBean(bean, annotatedClass);
        this.beans.add(NewEnterpriseBean.of(annotatedClass, this.manager));
    }

    private void createFacades(Set<? extends AnnotatedItem<?, ?>> injectionPoints) {
        for (AnnotatedItem<?, ?> injectionPoint : injectionPoints) {
            if (injectionPoint.isAnnotationPresent(Fires.class)) {
                this.createEvent(injectionPoint);
            }
            if (!injectionPoint.isAnnotationPresent(Obtains.class)) continue;
            this.createInstance(injectionPoint);
        }
    }

    private void createEvent(AnnotatedItem<?, ?> injectionPoint) {
        EventBean bean = EventBean.of(injectionPoint, this.manager);
        this.beans.add(bean);
        log.info("Web Bean: " + bean);
    }

    private void createInstance(AnnotatedItem<?, ?> injectionPoint) {
        InstanceBean bean = InstanceBean.of(injectionPoint, this.manager);
        this.beans.add(bean);
        log.info("Web Bean: " + bean);
    }

    private boolean isTypeSimpleWebBean(Class<?> type) {
        EJBApiAbstraction ejbApiAbstraction = new EJBApiAbstraction(this.manager.getResourceLoader());
        JSFApiAbstraction jsfApiAbstraction = new JSFApiAbstraction(this.manager.getResourceLoader());
        ServletApiAbstraction servletApiAbstraction = new ServletApiAbstraction(this.manager.getResourceLoader());
        return !type.isAnnotation() && !Reflections.isAbstract(type) && !servletApiAbstraction.SERVLET_CLASS.isAssignableFrom(type) && !servletApiAbstraction.FILTER_CLASS.isAssignableFrom(type) && !servletApiAbstraction.SERVLET_CONTEXT_LISTENER_CLASS.isAssignableFrom(type) && !servletApiAbstraction.HTTP_SESSION_LISTENER_CLASS.isAssignableFrom(type) && !servletApiAbstraction.SERVLET_REQUEST_LISTENER_CLASS.isAssignableFrom(type) && !ejbApiAbstraction.ENTERPRISE_BEAN_CLASS.isAssignableFrom(type) && !jsfApiAbstraction.UICOMPONENT_CLASS.isAssignableFrom(type) && BeanDeployer.hasSimpleWebBeanConstructor(type);
    }

    private static boolean hasSimpleWebBeanConstructor(Class<?> type) {
        try {
            type.getDeclaredConstructor(new Class[0]);
            return true;
        }
        catch (NoSuchMethodException nsme) {
            for (Constructor<?> c : type.getDeclaredConstructors()) {
                if (!c.isAnnotationPresent(Initializer.class)) continue;
                return true;
            }
            return false;
        }
    }

    private static <T> AnnotatedMethod<T> realizeProducerMethod(AnnotatedMethod<T> method, final AnnotatedClass<?> realizingClass) {
        return new WrappedAnnotatedMethod<T>(method, realizingClass.getMetaAnnotations(BindingType.class)){

            @Override
            public Set<Annotation> getMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
                if (metaAnnotationType.equals(DeploymentType.class)) {
                    return realizingClass.getMetaAnnotations(DeploymentType.class);
                }
                return super.getMetaAnnotations(metaAnnotationType);
            }

            @Override
            public Set<Annotation> getDeclaredMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
                if (metaAnnotationType.equals(DeploymentType.class)) {
                    return realizingClass.getDeclaredMetaAnnotations(DeploymentType.class);
                }
                return super.getDeclaredMetaAnnotations(metaAnnotationType);
            }
        };
    }

    private static <T> AnnotatedField<T> realizeProducerField(AnnotatedField<T> field, final AnnotatedClass<?> realizingClass) {
        return new WrappedAnnotatedField<T>(field, realizingClass.getMetaAnnotations(BindingType.class)){

            @Override
            public Set<Annotation> getMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
                if (metaAnnotationType.equals(DeploymentType.class)) {
                    return realizingClass.getMetaAnnotations(DeploymentType.class);
                }
                return super.getMetaAnnotations(metaAnnotationType);
            }

            @Override
            public Set<Annotation> getDeclaredMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
                if (metaAnnotationType.equals(DeploymentType.class)) {
                    return realizingClass.getDeclaredMetaAnnotations(DeploymentType.class);
                }
                return super.getDeclaredMetaAnnotations(metaAnnotationType);
            }
        };
    }
}

