/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.inject.ExecutionException;
import org.jboss.webbeans.bootstrap.WebBeansBootstrap;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.resources.spi.ResourceLoader;
import org.jboss.webbeans.servlet.ServletBootstrap;
import org.jboss.webbeans.util.DeploymentProperties;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertiesBasedBootstrap
extends WebBeansBootstrap {
    private static final LogProvider log = Logging.getLogProvider(ServletBootstrap.class);

    protected static <T> Constructor<? extends T> getClassConstructor(DeploymentProperties deploymentProperties, ResourceLoader resourceLoader, String propertyName, Class<T> expectedType, Class<?> ... constructorArguments) {
        for (Class<T> clazz : DeploymentProperties.getClasses(deploymentProperties, resourceLoader, propertyName, expectedType)) {
            Constructor<T> constructor = Reflections.getConstructor(clazz, constructorArguments);
            if (constructor == null) continue;
            return constructor;
        }
        return null;
    }

    protected static <T> T newInstance(Constructor<T> constructor, Object ... parameters) {
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalArgumentException e) {
            throw new ExecutionException("Error instantiating " + constructor, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ExecutionException("Error instantiating " + constructor, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException("Error instantiating " + constructor, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("Error instantiating " + constructor, (Throwable)e);
        }
    }

    protected abstract DeploymentProperties getDeploymentProperties();
}

