/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap;

import java.lang.annotation.Annotation;
import org.jboss.webbeans.BeanValidator;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.standard.InjectionPointBean;
import org.jboss.webbeans.bean.standard.ManagerBean;
import org.jboss.webbeans.bootstrap.BeanDeployer;
import org.jboss.webbeans.bootstrap.spi.EjbDiscovery;
import org.jboss.webbeans.bootstrap.spi.WebBeanDiscovery;
import org.jboss.webbeans.ejb.spi.EjbResolver;
import org.jboss.webbeans.literal.DeployedLiteral;
import org.jboss.webbeans.literal.InitializedLiteral;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.resources.spi.NamingContext;
import org.jboss.webbeans.resources.spi.ResourceLoader;
import org.jboss.webbeans.transaction.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebBeansBootstrap {
    private static LogProvider log = Logging.getLogProvider(WebBeansBootstrap.class);
    private ManagerImpl manager;

    protected void initManager(NamingContext namingContext, EjbResolver ejbResolver, ResourceLoader resourceLoader) {
        this.manager = new ManagerImpl(namingContext, ejbResolver, resourceLoader);
        this.manager.getNaming().bind("java:comp/Manager", (Object)this.getManager());
        CurrentManager.setRootManager(this.manager);
    }

    public ManagerImpl getManager() {
        return this.manager;
    }

    protected abstract WebBeanDiscovery getWebBeanDiscovery();

    protected abstract EjbDiscovery getEjbDiscovery();

    public abstract ResourceLoader getResourceLoader();

    protected void validateBootstrap() {
        if (this.getManager() == null) {
            throw new IllegalStateException("getManager() is not set on bootstrap");
        }
        if (this.getWebBeanDiscovery() == null) {
            throw new IllegalStateException("WebBeanDiscovery plugin not set on bootstrap");
        }
        if (this.getResourceLoader() == null) {
            throw new IllegalStateException("ResourceLoader plugin not set on bootstrap");
        }
    }

    protected void registerBeans(Iterable<Class<?>> classes) {
        BeanDeployer beanDeployer = new BeanDeployer(this.manager);
        beanDeployer.addClasses(classes);
        beanDeployer.addBean(ManagerBean.of(this.manager));
        beanDeployer.addBean(InjectionPointBean.of(this.manager));
        beanDeployer.addClass(Transaction.class);
        beanDeployer.deploy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boot() {
        WebBeansBootstrap webBeansBootstrap = this;
        synchronized (webBeansBootstrap) {
            log.info("Starting Web Beans RI " + WebBeansBootstrap.getVersion());
            this.validateBootstrap();
            this.getManager().getEjbDescriptorCache().addAll(this.getEjbDiscovery().discoverEjbs());
            this.registerBeans(this.getWebBeanDiscovery().discoverWebBeanClasses());
            this.getManager().fireEvent(this.getManager(), new Annotation[]{new InitializedLiteral()});
            log.info("Web Beans initialized. Validating beans.");
            this.getManager().getResolver().resolveInjectionPoints();
            new BeanValidator(this.manager).validate();
            this.getManager().fireEvent(this.getManager(), new Annotation[]{new DeployedLiteral()});
        }
    }

    public static String getVersion() {
        Package pkg = WebBeansBootstrap.class.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : null;
    }
}

