/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.context;

import java.lang.annotation.Annotation;
import javax.context.ContextNotActiveException;
import javax.context.Contextual;
import javax.context.CreationalContext;
import org.jboss.webbeans.context.AbstractContext;
import org.jboss.webbeans.context.beanmap.BeanMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBeanMapContext
extends AbstractContext {
    public AbstractBeanMapContext(Class<? extends Annotation> scopeType) {
        super(scopeType);
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        Object instance = this.getBeanMap().get(contextual);
        if (instance != null) {
            return instance;
        }
        if (creationalContext != null) {
            instance = contextual.create(creationalContext);
            this.getBeanMap().put(contextual, instance);
            return instance;
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    private <T> void destroy(Contextual<T> bean) {
        bean.destroy(this.getBeanMap().get(bean));
    }

    public void destroy() {
        for (Contextual<? extends Object> bean : this.getBeanMap().keySet()) {
            this.destroy(bean);
        }
        this.getBeanMap().clear();
    }

    protected abstract BeanMap getBeanMap();
}

