/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.context;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.context.Context;
import org.jboss.webbeans.context.AbstractContext;
import org.jboss.webbeans.util.ConcurrentCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextMap
extends ConcurrentCache<Class<? extends Annotation>, List<Context>> {
    public AbstractContext getBuiltInContext(Class<? extends Annotation> scopeType) {
        if (this.getContext(scopeType) != null) {
            return (AbstractContext)this.getContext(scopeType).get(0);
        }
        return null;
    }

    public List<Context> getContext(Class<? extends Annotation> scopeType) {
        List contexts = (List)this.getValue(scopeType);
        if (contexts == null) {
            return Collections.emptyList();
        }
        return contexts;
    }

    public String toString() {
        return "ContextMap holding " + this.delegate().size() + " contexts: " + this.delegate().keySet();
    }

    public void add(Context context) {
        List<Context> contexts = this.putIfAbsent(context.getScopeType(), new Callable<List<Context>>(){

            @Override
            public List<Context> call() throws Exception {
                return new CopyOnWriteArrayList<Context>();
            }
        });
        contexts.add(context);
    }
}

