/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.context;

import java.util.concurrent.atomic.AtomicInteger;
import javax.context.ContextNotActiveException;
import javax.context.Contextual;
import javax.context.CreationalContext;
import javax.context.Dependent;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.context.AbstractContext;
import org.jboss.webbeans.context.ContextualInstance;
import org.jboss.webbeans.context.DependentInstancesStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependentContext
extends AbstractContext {
    public static DependentContext INSTANCE = new DependentContext();
    private ThreadLocal<AtomicInteger> reentrantActiveCount;
    private ThreadLocal<Object> currentInjectionInstance;

    public DependentContext() {
        super(Dependent.class);
        super.setActive(false);
        this.reentrantActiveCount = new ThreadLocal<AtomicInteger>(){

            @Override
            protected AtomicInteger initialValue() {
                return new AtomicInteger(0);
            }
        };
        this.currentInjectionInstance = new ThreadLocal();
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        if (creationalContext != null) {
            Object instance = contextual.create(creationalContext);
            if (contextual instanceof AbstractClassBean && this.currentInjectionInstance.get() != null) {
                DependentInstancesStore dependentInstancesStore = ((AbstractClassBean)contextual).getDependentInstancesStore();
                dependentInstancesStore.addDependentInstance(this.currentInjectionInstance.get(), ContextualInstance.of(contextual, instance));
            }
            return (T)instance;
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public String toString() {
        String active = this.isActive() ? "Active " : "Inactive ";
        return active + "dependent context";
    }

    @Override
    public void setActive(boolean active) {
        if (active) {
            if (this.reentrantActiveCount.get().incrementAndGet() == 1) {
                super.setActive(true);
            }
        } else if (this.reentrantActiveCount.get().decrementAndGet() == 0) {
            super.setActive(false);
        }
    }

    public void setCurrentInjectionInstance(Object instance) {
        if (this.currentInjectionInstance.get() == null) {
            this.currentInjectionInstance.set(instance);
        }
    }

    public void clearCurrentInjectionInstance(Object instance) {
        if (this.currentInjectionInstance.get() == instance) {
            this.currentInjectionInstance.set(null);
        }
    }
}

