/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.context.beanmap;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.context.Contextual;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.context.beanmap.BeanMap;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.servlet.ApplicationBeanMap;
import org.jboss.webbeans.util.Names;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBeanMap
implements BeanMap {
    private static LogProvider log = Logging.getLogProvider(ApplicationBeanMap.class);

    @Override
    public <T> T get(Contextual<? extends T> bean) {
        String key = this.getBeanKey(bean);
        Object instance = this.getAttribute(key);
        log.trace("Looked for " + key + " and got " + instance);
        return (T)instance;
    }

    @Override
    public <T> T remove(Contextual<? extends T> bean) {
        T instance = this.get(bean);
        String key = this.getBeanKey(bean);
        this.removeAttribute(key);
        log.trace("Removed bean under key " + key);
        return instance;
    }

    @Override
    public void clear() {
        Enumeration<String> names = this.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            this.removeAttribute(name);
            log.trace("Cleared " + name);
        }
        log.trace("Bean Map cleared");
    }

    @Override
    public Iterable<Contextual<? extends Object>> keySet() {
        ArrayList<Contextual<? extends Object>> beans = new ArrayList<Contextual<? extends Object>>();
        Enumeration<String> names = this.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            if (!name.startsWith(this.getKeyPrefix())) continue;
            String id = name.substring(this.getKeyPrefix().length() + 1);
            Contextual bean = (Contextual)CurrentManager.rootManager().getBeans().get(Integer.parseInt(id));
            beans.add((Contextual<? extends Object>)bean);
        }
        return beans;
    }

    @Override
    public <T> void put(Contextual<? extends T> bean, T instance) {
        String key = this.getBeanKey(bean);
        this.setAttribute(key, instance);
        log.trace("Added bean " + bean + " under key " + key);
    }

    protected abstract Object getAttribute(String var1);

    protected abstract void removeAttribute(String var1);

    protected abstract Enumeration<String> getAttributeNames();

    protected abstract void setAttribute(String var1, Object var2);

    protected abstract String getKeyPrefix();

    protected String getBeanKey(Contextual<?> bean) {
        return this.getKeyPrefix() + "#" + CurrentManager.rootManager().getBeans().indexOf(bean);
    }

    public String toString() {
        return "holding " + Names.count(this.keySet()) + " instances under the key prefix " + this.getKeyPrefix();
    }
}

