/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.context.beanmap;

import com.google.common.collect.ForwardingMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.context.Contextual;
import org.jboss.webbeans.context.beanmap.BeanMap;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBeanMap
extends ForwardingMap<Contextual<? extends Object>, Object>
implements BeanMap {
    private static LogProvider log = Logging.getLogProvider(SimpleBeanMap.class);
    protected Map<Contextual<? extends Object>, Object> delegate = new ConcurrentHashMap<Contextual<? extends Object>, Object>();

    @Override
    public <T> T get(Contextual<? extends T> bean) {
        Object instance = super.get(bean);
        log.trace("Searched bean map for " + bean + " and got " + instance);
        return (T)instance;
    }

    public Map<Contextual<? extends Object>, Object> delegate() {
        return this.delegate;
    }

    @Override
    public <T> T remove(Contextual<? extends T> bean) {
        Object instance = super.remove(bean);
        log.trace("Removed instace " + instance + " for bean " + bean + " from the bean map");
        return (T)instance;
    }

    @Override
    public void clear() {
        this.delegate.clear();
        log.trace("Bean map cleared");
    }

    public Set<Contextual<? extends Object>> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public <T> void put(Contextual<? extends T> bean, T instance) {
        this.delegate.put(bean, instance);
        log.trace("Stored instance " + instance + " for bean " + bean + " in bean map");
    }

    public String toString() {
        return "holding " + this.delegate.size() + " instances";
    }
}

