/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.ejb;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.webbeans.ejb.InternalEjbDescriptor;
import org.jboss.webbeans.ejb.spi.EjbDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbDescriptorCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ConcurrentMap<String, InternalEjbDescriptor<?>> ejbsByName = new ConcurrentHashMap();
    private ConcurrentMap<Class<?>, Set<InternalEjbDescriptor<?>>> ejbsByBeanClass = new ConcurrentHashMap();

    public InternalEjbDescriptor<?> get(String ejbName) {
        return (InternalEjbDescriptor)this.ejbsByName.get(ejbName);
    }

    public <T> Iterable<InternalEjbDescriptor<T>> get(Class<T> beanClass) {
        return (Iterable)this.ejbsByBeanClass.get(beanClass);
    }

    public <T> void add(EjbDescriptor<T> ejbDescriptor) {
        InternalEjbDescriptor<T> internalEjbDescriptor = new InternalEjbDescriptor<T>(ejbDescriptor);
        this.ejbsByName.put(ejbDescriptor.getEjbName(), internalEjbDescriptor);
        this.ejbsByBeanClass.putIfAbsent(ejbDescriptor.getType(), new CopyOnWriteArraySet());
        ((Set)this.ejbsByBeanClass.get(ejbDescriptor.getType())).add(internalEjbDescriptor);
    }

    public boolean containsKey(String ejbName) {
        return this.ejbsByName.containsKey(ejbName);
    }

    public boolean containsKey(Class<?> beanClass) {
        return this.ejbsByBeanClass.containsKey(beanClass);
    }

    public void addAll(Iterable<EjbDescriptor<?>> ejbDescriptors) {
        for (EjbDescriptor<?> ejbDescriptor : ejbDescriptors) {
            this.add(ejbDescriptor);
        }
    }

    public void clear() {
        this.ejbsByBeanClass.clear();
        this.ejbsByName.clear();
    }

    public String toString() {
        return "EJB Descriptor cache has indexed " + this.ejbsByBeanClass.size() + " EJBs by class and " + this.ejbsByName + " by name";
    }
}

