/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.ejb;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.interceptor.InvocationContext;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.bean.proxy.EnterpriseBeanProxyMethodHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionBeanInterceptor {
    @PostConstruct
    public void postConstruct(InvocationContext invocationContext) throws Exception {
        Object target = invocationContext.getTarget();
        EnterpriseBean<?> enterpriseBean = SessionBeanInterceptor.getBean(target.getClass());
        if (enterpriseBean != null) {
            enterpriseBean.postConstruct(target);
        }
        invocationContext.proceed();
    }

    @PreDestroy
    public void preDestroy(InvocationContext invocationContext) throws Exception {
        Object target = invocationContext.getTarget();
        EnterpriseBean<?> enterpriseBean = SessionBeanInterceptor.getBean(target.getClass());
        if (enterpriseBean != null) {
            enterpriseBean.preDestroy(target);
        }
        invocationContext.proceed();
    }

    private static <T> EnterpriseBean<T> getBean(Class<? extends T> beanClass) {
        if (EnterpriseBeanProxyMethodHandler.isContextualInstance(beanClass)) {
            return CurrentManager.rootManager().getEnterpriseBeanMap().get(beanClass);
        }
        return CurrentManager.rootManager().getNewEnterpriseBeanMap().get(beanClass);
    }
}

