/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.event;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.event.Event;
import javax.event.Fires;
import javax.event.Observer;
import javax.inject.manager.Manager;
import org.jboss.webbeans.FacadeImpl;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventImpl<T>
extends FacadeImpl<T>
implements Event<T> {
    private static final Set<Class<? extends Annotation>> FILTERED_ANNOTATIONS = new HashSet<Class>(Arrays.asList(Fires.class));

    public EventImpl(Class<T> eventType, Manager manager, Annotation ... bindingTypes) {
        super(eventType, manager, bindingTypes);
    }

    public void fire(T event, Annotation ... bindingTypes) {
        this.manager.fireEvent(event, this.mergeBindings(bindingTypes));
    }

    public void observe(Observer<T> observer, Annotation ... bindingTypes) {
        this.manager.addObserver(observer, this.type, this.mergeBindings(bindingTypes));
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Observable Event:\n");
        buffer.append("  Event Type: " + this.type.getName() + "\n");
        buffer.append(Strings.collectionToString("  Event Bindings: ", this.bindingTypes));
        return buffer.toString();
    }

    @Override
    protected Set<Class<? extends Annotation>> getFilteredAnnotations() {
        return FILTERED_ANNOTATIONS;
    }
}

