/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.event;

import com.google.common.collect.ForwardingMap;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.event.Observer;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.event.EventObserver;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager {
    private final RegisteredObserversMap registeredObservers = new RegisteredObserversMap();

    public <T> void addObserver(Observer<T> observer, Class<T> eventType, Annotation ... bindings) {
        EventObserver<T> eventObserver = new EventObserver<T>(observer, eventType, bindings);
        this.registeredObservers.put(eventType, eventObserver);
    }

    public <T> Set<Observer<T>> getObservers(T event, Annotation ... bindings) {
        HashSet<Observer<T>> interestedObservers = new HashSet<Observer<T>>();
        for (Class<?> clazz : Reflections.getTypeHierachy(event.getClass())) {
            Iterator i$ = ((CopyOnWriteArrayList)this.registeredObservers.get(clazz)).iterator();
            while (i$.hasNext()) {
                EventObserver observer = (EventObserver)i$.next();
                if (!observer.isObserverInterested(bindings)) continue;
                Observer o = observer.getObserver();
                interestedObservers.add(o);
            }
        }
        return interestedObservers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void notifyObservers(Set<Observer<T>> observers, T event) {
        try {
            DependentContext.INSTANCE.setActive(true);
            for (Observer<T> observer : observers) {
                observer.notify(event);
            }
        }
        finally {
            DependentContext.INSTANCE.setActive(false);
        }
    }

    public <T> void removeObserver(Observer<T> observer, Class<T> eventType, Annotation ... bindings) {
        Object observers = this.registeredObservers.get(eventType);
        EventObserver<T> eventObserver = new EventObserver<T>(observer, eventType, bindings);
        observers.remove(eventObserver);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Event manager\n");
        buffer.append(this.registeredObservers.toString());
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RegisteredObserversMap
    extends ForwardingMap<Class<?>, List<EventObserver<?>>> {
        private ConcurrentHashMap<Class<?>, List<EventObserver<?>>> delegate = new ConcurrentHashMap();

        protected Map<Class<?>, List<EventObserver<?>>> delegate() {
            return this.delegate;
        }

        public CopyOnWriteArrayList<EventObserver<?>> get(Object eventType) {
            CopyOnWriteArrayList observers = (CopyOnWriteArrayList)super.get(eventType);
            return observers != null ? observers : new CopyOnWriteArrayList();
        }

        public void put(Class<?> eventType, EventObserver<?> observer) {
            CopyOnWriteArrayList observers = (CopyOnWriteArrayList)super.get(eventType);
            if (observers == null) {
                observers = new CopyOnWriteArrayList();
                super.put(eventType, observers);
            }
            if (!observers.contains(observer)) {
                observers.add(observer);
            }
        }

        public String toString() {
            return Strings.mapToString("RegisteredObserversMap (event type -> observers list): ", this.delegate);
        }
    }
}

