/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.event;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.context.Dependent;
import javax.event.AfterTransactionCompletion;
import javax.event.AfterTransactionFailure;
import javax.event.AfterTransactionSuccess;
import javax.event.BeforeTransactionCompletion;
import javax.event.IfExists;
import javax.event.Observer;
import javax.event.ObserverException;
import javax.event.Observes;
import javax.inject.DefinitionException;
import javax.inject.Disposes;
import javax.inject.Initializer;
import javax.inject.Produces;
import javax.inject.manager.Bean;
import javax.transaction.SystemException;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.event.DeferredEventNotification;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.transaction.UserTransaction;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObserverImpl<T>
implements Observer<T> {
    private final Bean<?> observerBean;
    private final MethodInjectionPoint<?> observerMethod;
    private TransactionObservationPhase transactionObservationPhase;
    private final boolean conditional;
    private ManagerImpl manager;
    private final Class<T> eventType;
    private final Annotation[] bindings;

    public static <T> ObserverImpl<T> of(AnnotatedMethod<?> method, AbstractClassBean<?> declaringBean, ManagerImpl manager) {
        return new ObserverImpl<T>(method, declaringBean, manager);
    }

    protected ObserverImpl(AnnotatedMethod<?> observer, Bean<?> observerBean, ManagerImpl manager) {
        this.manager = manager;
        this.observerBean = observerBean;
        this.observerMethod = MethodInjectionPoint.of(observerBean, observer);
        this.checkObserverMethod();
        Class c = this.observerMethod.getAnnotatedParameters(Observes.class).get(0).getType();
        this.eventType = c;
        this.bindings = this.observerMethod.getAnnotatedParameters(Observes.class).get(0).getBindingTypesAsArray();
        this.initTransactionObservationPhase();
        this.conditional = !this.observerMethod.getAnnotatedParameters(IfExists.class).isEmpty();
    }

    private void initTransactionObservationPhase() {
        ArrayList<TransactionObservationPhase> observationPhases = new ArrayList<TransactionObservationPhase>();
        if (!this.observerMethod.getAnnotatedParameters(BeforeTransactionCompletion.class).isEmpty()) {
            observationPhases.add(TransactionObservationPhase.BEFORE_COMPLETION);
        }
        if (!this.observerMethod.getAnnotatedParameters(AfterTransactionCompletion.class).isEmpty()) {
            observationPhases.add(TransactionObservationPhase.AFTER_COMPLETION);
        }
        if (!this.observerMethod.getAnnotatedParameters(AfterTransactionFailure.class).isEmpty()) {
            observationPhases.add(TransactionObservationPhase.AFTER_FAILURE);
        }
        if (!this.observerMethod.getAnnotatedParameters(AfterTransactionSuccess.class).isEmpty()) {
            observationPhases.add(TransactionObservationPhase.AFTER_SUCCESS);
        }
        if (observationPhases.size() > 1) {
            throw new DefinitionException("Transactional observers can only observe on a single phase");
        }
        this.transactionObservationPhase = observationPhases.size() == 1 ? (TransactionObservationPhase)((Object)observationPhases.iterator().next()) : TransactionObservationPhase.NONE;
    }

    private void checkObserverMethod() {
        AnnotatedParameter<?> eventParam;
        List<AnnotatedParameter<?>> eventObjects = this.observerMethod.getAnnotatedParameters(Observes.class);
        if (eventObjects.size() > 1) {
            throw new DefinitionException(this + " is invalid because it contains more than event parameter annotated @Observes");
        }
        if (eventObjects.size() > 0 && Reflections.isParameterizedType((eventParam = eventObjects.iterator().next()).getType())) {
            throw new DefinitionException(this + " cannot observe parameterized event types");
        }
        List<AnnotatedParameter<?>> disposeParams = this.observerMethod.getAnnotatedParameters(Disposes.class);
        if (disposeParams.size() > 0) {
            throw new DefinitionException(this + " cannot have any parameters annotated with @Dispose");
        }
        if (this.observerMethod.isAnnotationPresent(Produces.class)) {
            throw new DefinitionException(this + " cannot be annotated with @Produces");
        }
        if (this.observerMethod.isAnnotationPresent(Initializer.class)) {
            throw new DefinitionException(this + " cannot be annotated with @Initializer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(T event) {
        Object instance = null;
        Object dependentsCollector = new Object();
        try {
            if (Dependent.class.equals((Object)this.observerBean.getScopeType()) && this.observerBean instanceof RIBean) {
                DependentContext.INSTANCE.setCurrentInjectionInstance(dependentsCollector);
            }
            if ((instance = this.getInstance(this.observerBean)) == null) {
                return;
            }
            if (this.isTransactional() && this.isTransactionActive()) {
                this.deferEvent(event);
            } else {
                this.observerMethod.invokeWithSpecialValue(instance, Observes.class, event, this.manager, null, ObserverException.class);
            }
        }
        finally {
            if (Dependent.class.equals((Object)this.observerBean.getScopeType())) {
                ((AbstractBean)this.observerBean).getDependentInstancesStore().destroyDependentInstances(dependentsCollector);
                DependentContext.INSTANCE.clearCurrentInjectionInstance(instance);
            }
        }
    }

    private <B> B getInstance(Bean<B> observerBean) {
        return this.manager.getInstance(observerBean, !this.isConditional());
    }

    private boolean isTransactionActive() {
        UserTransaction userTransaction = this.manager.getInstanceByType(UserTransaction.class, new Annotation[0]);
        try {
            return userTransaction != null && userTransaction.getStatus() == 0;
        }
        catch (SystemException e) {
            return false;
        }
    }

    private void deferEvent(T event) {
        UserTransaction userTransaction = this.manager.getInstanceByType(UserTransaction.class, new Annotation[0]);
        DeferredEventNotification<T> deferredEvent = new DeferredEventNotification<T>(event, this);
        userTransaction.registerSynchronization(deferredEvent);
    }

    public boolean isTransactional() {
        return !TransactionObservationPhase.NONE.equals((Object)this.transactionObservationPhase);
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public boolean isInterestedInTransactionPhase(TransactionObservationPhase currentPhase) {
        return this.transactionObservationPhase.equals((Object)currentPhase);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Observer Implentation: \n");
        builder.append("  Observer (Declaring) bean: " + this.observerBean);
        builder.append("  Observer method: " + this.observerMethod);
        return builder.toString();
    }

    public Class<T> getEventType() {
        return this.eventType;
    }

    public Annotation[] getBindingsAsArray() {
        return this.bindings;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TransactionObservationPhase {
        NONE,
        BEFORE_COMPLETION,
        AFTER_COMPLETION,
        AFTER_FAILURE,
        AFTER_SUCCESS;

    }
}

