/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.context.CreationalContext;
import javax.inject.manager.Bean;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.injection.AnnotatedInjectionPoint;
import org.jboss.webbeans.injection.Exceptions;
import org.jboss.webbeans.injection.ParameterInjectionPoint;
import org.jboss.webbeans.introspector.AnnotatedConstructor;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.introspector.ForwardingAnnotatedConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorInjectionPoint<T>
extends ForwardingAnnotatedConstructor<T>
implements AnnotatedInjectionPoint<T, Constructor<T>> {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final Bean<?> declaringBean;
    private final AnnotatedConstructor<T> constructor;

    public static <T> ConstructorInjectionPoint<T> of(Bean<?> declaringBean, AnnotatedConstructor<T> constructor) {
        return new ConstructorInjectionPoint<T>(declaringBean, constructor);
    }

    protected ConstructorInjectionPoint(Bean<?> declaringBean, AnnotatedConstructor<T> constructor) {
        this.declaringBean = declaringBean;
        this.constructor = constructor;
    }

    @Override
    protected AnnotatedConstructor<T> delegate() {
        return this.constructor;
    }

    public Annotation[] getAnnotations() {
        return this.delegate().getAnnotationStore().getAnnotations().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    public Bean<?> getBean() {
        return this.declaringBean;
    }

    public Set<Annotation> getBindings() {
        return this.delegate().getBindingTypes();
    }

    public T newInstance(ManagerImpl manager, CreationalContext<?> creationalContext) {
        try {
            return this.delegate().newInstance(this.getParameterValues(this.getParameters(), null, null, manager, creationalContext));
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (InstantiationException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e);
        }
        return null;
    }

    @Override
    public List<ParameterInjectionPoint<?>> getParameters() {
        final List<AnnotatedParameter<?>> delegate = super.getParameters();
        return new ForwardingParameterInjectionPointList(){

            @Override
            protected Bean<?> declaringBean() {
                return ConstructorInjectionPoint.this.declaringBean;
            }

            @Override
            protected List<? extends AnnotatedParameter<?>> delegate() {
                return delegate;
            }
        };
    }

    @Override
    public void inject(Object declaringInstance, Object value) {
        throw new UnsupportedOperationException();
    }

    protected Object[] getParameterValues(List<ParameterInjectionPoint<?>> parameters, Object specialVal, Class<? extends Annotation> specialParam, ManagerImpl manager, CreationalContext<?> creationalContext) {
        Object[] parameterValues = new Object[parameters.size()];
        Iterator<ParameterInjectionPoint<?>> iterator = parameters.iterator();
        for (int i = 0; i < parameterValues.length; ++i) {
            ParameterInjectionPoint<?> param = iterator.next();
            parameterValues[i] = specialParam != null && param.isAnnotationPresent(specialParam) ? specialVal : param.getValueToInject(manager, creationalContext);
        }
        return parameterValues;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ForwardingParameterInjectionPointList
    extends AbstractList<ParameterInjectionPoint<?>> {
        private ForwardingParameterInjectionPointList() {
        }

        protected abstract List<? extends AnnotatedParameter<?>> delegate();

        protected abstract Bean<?> declaringBean();

        @Override
        public ParameterInjectionPoint<?> get(int index) {
            return ParameterInjectionPoint.of(ConstructorInjectionPoint.this.declaringBean, this.delegate().get(index));
        }

        @Override
        public int size() {
            return this.delegate().size();
        }
    }
}

