/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Set;
import javax.context.CreationalContext;
import javax.inject.manager.Bean;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.injection.AnnotatedInjectionPoint;
import org.jboss.webbeans.injection.Exceptions;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.introspector.ForwardingAnnotatedField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInjectionPoint<T>
extends ForwardingAnnotatedField<T>
implements AnnotatedInjectionPoint<T, Field> {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final Bean<?> declaringBean;
    private final AnnotatedField<T> field;

    public static <T> FieldInjectionPoint<T> of(Bean<?> declaringBean, AnnotatedField<T> field) {
        return new FieldInjectionPoint<T>(declaringBean, field);
    }

    protected FieldInjectionPoint(Bean<?> declaringBean, AnnotatedField<T> field) {
        this.declaringBean = declaringBean;
        this.field = field;
    }

    @Override
    protected AnnotatedField<T> delegate() {
        return this.field;
    }

    public Annotation[] getAnnotations() {
        return this.delegate().getAnnotationStore().getAnnotations().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    public Bean<?> getBean() {
        return this.declaringBean;
    }

    public Set<Annotation> getBindings() {
        return this.delegate().getAnnotationStore().getBindingTypes();
    }

    public void inject(Object declaringInstance, ManagerImpl manager, CreationalContext<?> creationalContext) {
        try {
            this.delegate().set(declaringInstance, manager.getInstanceToInject(this, creationalContext));
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
    }

    @Override
    public void inject(Object declaringInstance, Object value) {
        try {
            this.delegate().set(declaringInstance, value);
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
    }
}

