/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.inject.TypeLiteral;
import javax.inject.manager.Bean;
import javax.inject.manager.Decorator;
import javax.inject.manager.InterceptionType;
import javax.inject.manager.Interceptor;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.introspector.ForwardingAnnotatedItem;
import org.jboss.webbeans.metadata.BindingTypeModel;
import org.jboss.webbeans.metadata.MetaDataCache;
import org.jboss.webbeans.util.ConcurrentCache;
import org.jboss.webbeans.util.ListComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolver {
    private static final long serialVersionUID = 1L;
    private static final Class<AnnotatedItem<Object, Object>> ANNOTATED_ITEM_GENERIFIED_WITH_OBJECT_OBJECT = new TypeLiteral<AnnotatedItem<Object, Object>>(){}.getRawType();
    private static final Class<Set<Bean<Object>>> BEAN_SET_GENERIFIED_WITH_OBJECT = new TypeLiteral<Set<Bean<Object>>>(){}.getRawType();
    private static final Class<Set<Bean<?>>> BEAN_SET_GENERIFIED_WITH_WILDCARD = new TypeLiteral<Set<Bean<?>>>(){}.getRawType();
    private ConcurrentCache<ResolvableAnnotatedItem<?, ?>, Set<Bean<?>>> resolvedInjectionPoints;
    private Set<AnnotatedItem<?, ?>> injectionPoints = new HashSet();
    private ConcurrentCache<String, Set<Bean<?>>> resolvedNames;
    private ManagerImpl manager;

    public Resolver(ManagerImpl manager) {
        this.resolvedInjectionPoints = new ConcurrentCache();
        this.resolvedNames = new ConcurrentCache();
        this.manager = manager;
    }

    public void addInjectionPoints(Collection<? extends AnnotatedItem<?, ?>> elements) {
        this.injectionPoints.addAll(elements);
    }

    private <T, S> Set<Bean<T>> registerInjectionPoint(final ResolvableAnnotatedItem<T, S> element) {
        Callable callable = new Callable<Set<Bean<T>>>(){

            @Override
            public Set<Bean<T>> call() throws Exception {
                return Resolver.retainHighestPrecedenceBeans(Resolver.this.getMatchingBeans(element, Resolver.this.manager.getBeans()), Resolver.this.manager.getEnabledDeploymentTypes());
            }
        };
        return (Set)this.resolvedInjectionPoints.putIfAbsent(element, callable);
    }

    public void clear() {
        this.resolvedInjectionPoints = new ConcurrentCache();
        this.resolvedNames = new ConcurrentCache();
    }

    public void resolveInjectionPoints() {
        for (final AnnotatedItem<?, ?> injectable : this.injectionPoints) {
            this.registerInjectionPoint(new ResolvableAnnotatedItem<Object, Object>(){
                private static final long serialVersionUID = 1L;

                @Override
                public AnnotatedItem<Object, Object> delegate() {
                    return (AnnotatedItem)ANNOTATED_ITEM_GENERIFIED_WITH_OBJECT_OBJECT.cast(injectable);
                }
            });
        }
    }

    public <T, S> Set<Bean<T>> get(final AnnotatedItem<T, S> key) {
        Set<Object> beans = new HashSet();
        ResolvableAnnotatedItem element = new ResolvableAnnotatedItem<T, S>(){

            @Override
            public AnnotatedItem<T, S> delegate() {
                return key;
            }
        };
        beans = this.registerInjectionPoint(element);
        return Collections.unmodifiableSet(beans);
    }

    public Set<Bean<? extends Object>> get(final String name) {
        return (Set)this.resolvedNames.putIfAbsent(name, new Callable<Set<Bean<?>>>(){

            @Override
            public Set<Bean<? extends Object>> call() throws Exception {
                HashSet beans = new HashSet();
                for (Bean<?> bean : Resolver.this.manager.getBeans()) {
                    if ((bean.getName() != null || name != null) && (bean.getName() == null || !bean.getName().equals(name))) continue;
                    beans.add(bean);
                }
                return this.retainHighestPrecedenceBeans(beans, Resolver.this.manager.getEnabledDeploymentTypes());
            }

            private Set<Bean<?>> retainHighestPrecedenceBeans(Set<Bean<?>> beans, List<Class<? extends Annotation>> enabledDeploymentTypes) {
                return (Set)BEAN_SET_GENERIFIED_WITH_WILDCARD.cast(Resolver.retainHighestPrecedenceBeans((Set)BEAN_SET_GENERIFIED_WITH_OBJECT.cast(beans), enabledDeploymentTypes));
            }
        });
    }

    private static <T> Set<Bean<T>> retainHighestPrecedenceBeans(Set<Bean<T>> beans, List<Class<? extends Annotation>> enabledDeploymentTypes) {
        if (beans.size() > 0) {
            TreeSet<Class<? extends Annotation>> possibleDeploymentTypes = new TreeSet<Class<? extends Annotation>>(new ListComparator<Class<? extends Annotation>>(enabledDeploymentTypes));
            for (Bean<T> bean : beans) {
                possibleDeploymentTypes.add(bean.getDeploymentType());
            }
            possibleDeploymentTypes.retainAll(enabledDeploymentTypes);
            HashSet<Bean<T>> trimmed = new HashSet<Bean<T>>();
            if (possibleDeploymentTypes.size() > 0) {
                Class highestPrecedencePossibleDeploymentType = (Class)possibleDeploymentTypes.last();
                for (Bean<T> bean : beans) {
                    if (!bean.getDeploymentType().equals(highestPrecedencePossibleDeploymentType)) continue;
                    trimmed.add(bean);
                }
            }
            return trimmed;
        }
        return beans;
    }

    private <T> Set<Bean<T>> getMatchingBeans(AnnotatedItem<T, ?> element, List<Bean<?>> beans) {
        HashSet<Bean<T>> resolvedBeans = new HashSet<Bean<T>>();
        for (Bean<?> bean : beans) {
            if (!element.isAssignableFrom(bean.getTypes()) || !this.containsAllBindingBindingTypes(element, bean.getBindings())) continue;
            Bean<?> b = bean;
            resolvedBeans.add(b);
        }
        return resolvedBeans;
    }

    private boolean containsAllBindingBindingTypes(AnnotatedItem<?, ?> element, Set<Annotation> bindingTypes) {
        for (Annotation bindingType : element.getBindingTypes()) {
            BindingTypeModel<? extends Annotation> bindingTypeModel = MetaDataCache.instance().getBindingTypeModel(bindingType.annotationType());
            if (bindingTypeModel.getNonBindingTypes().size() > 0) {
                boolean matchFound = false;
                for (Annotation otherBindingType : bindingTypes) {
                    if (!bindingTypeModel.isEqual(bindingType, otherBindingType)) continue;
                    matchFound = true;
                }
                if (matchFound) continue;
                return false;
            }
            if (bindingTypes.contains(bindingType)) continue;
            return false;
        }
        return true;
    }

    public List<Decorator> resolveDecorators(Set<Type> types, Annotation[] bindingTypes) {
        return Collections.emptyList();
    }

    public List<Interceptor> resolveInterceptors(InterceptionType type, Annotation[] interceptorBindings) {
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Resolver\n");
        buffer.append("Injection points: " + this.injectionPoints.size() + "\n");
        buffer.append("Resolved injection points: " + this.resolvedInjectionPoints.size() + "\n");
        buffer.append("Resolved names points: " + this.resolvedNames.size() + "\n");
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ResolvableAnnotatedItem<T, S>
    extends ForwardingAnnotatedItem<T, S> {
        private static final long serialVersionUID = 1L;

        private ResolvableAnnotatedItem() {
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof AnnotatedItem) {
                AnnotatedItem that = (AnnotatedItem)other;
                return this.delegate().isAssignableFrom(that) && ((Object)that.getBindingTypes()).equals(this.getBindingTypes());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.delegate().hashCode();
        }

        @Override
        public String toString() {
            return "Resolvable annotated item for " + this.delegate();
        }
    }
}

