/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector;

import com.google.common.collect.ForwardingMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.BindingType;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.literal.CurrentLiteral;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationStore {
    private static final Annotation[] DEFAULT_BINDING_ARRAY = new Annotation[]{new CurrentLiteral()};
    private static final Set<Annotation> DEFAULT_BINDING = new HashSet<Annotation>(Arrays.asList(DEFAULT_BINDING_ARRAY));
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final AnnotationMap annotationMap;
    private final MetaAnnotationMap metaAnnotationMap;
    private final Set<Annotation> annotationSet;
    private final AnnotationMap declaredAnnotationMap;
    private final MetaAnnotationMap declaredMetaAnnotationMap;
    private final Set<Annotation> declaredAnnotationSet;

    protected static AnnotationMap buildAnnotationMap(Annotation[] annotations) {
        AnnotationMap annotationMap = new AnnotationMap();
        for (Annotation annotation : annotations) {
            annotationMap.put(annotation.annotationType(), annotation);
        }
        return annotationMap;
    }

    protected static AnnotationMap buildAnnotationMap(Iterable<Annotation> annotations) {
        AnnotationMap annotationMap = new AnnotationMap();
        for (Annotation annotation : annotations) {
            annotationMap.put(annotation.annotationType(), annotation);
        }
        return annotationMap;
    }

    public static AnnotationStore of(AnnotatedElement annotatedElement) {
        return new AnnotationStore(AnnotationStore.buildAnnotationMap(annotatedElement.getAnnotations()), AnnotationStore.buildAnnotationMap(annotatedElement.getDeclaredAnnotations()));
    }

    public static AnnotationStore of(Annotation[] annotations, Annotation[] declaredAnnotations) {
        return new AnnotationStore(AnnotationStore.buildAnnotationMap(annotations), AnnotationStore.buildAnnotationMap(declaredAnnotations));
    }

    public static AnnotationStore wrap(AnnotationStore annotationStore, Set<Annotation> annotations, Set<Annotation> declaredAnnotations) {
        AnnotationMap annotationMap = new AnnotationMap();
        annotationMap.putAll((Map)((Object)AnnotationStore.buildAnnotationMap(annotations)));
        annotationMap.putAll((Map)((Object)annotationStore.getAnnotationMap()));
        AnnotationMap declaredAnnotationMap = new AnnotationMap();
        declaredAnnotationMap.putAll((Map)((Object)AnnotationStore.buildAnnotationMap(declaredAnnotations)));
        declaredAnnotationMap.putAll((Map)((Object)annotationStore.getDeclaredAnnotationMap()));
        return new AnnotationStore(annotationMap, declaredAnnotationMap);
    }

    protected AnnotationStore(AnnotationMap annotationMap, AnnotationMap declaredAnnotationMap) {
        if (annotationMap == null) {
            throw new NullPointerException("annotationMap cannot be null");
        }
        this.annotationMap = annotationMap;
        this.annotationSet = new HashSet<Annotation>();
        this.metaAnnotationMap = new MetaAnnotationMap();
        for (Annotation annotation : annotationMap.values()) {
            for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                if (!AnnotatedItem.MAPPED_METAANNOTATIONS.contains(metaAnnotation.annotationType())) continue;
                this.metaAnnotationMap.put(metaAnnotation.annotationType(), annotation);
            }
            this.annotationSet.add(annotation);
        }
        if (declaredAnnotationMap == null) {
            throw new NullPointerException("declaredAnnotationMap cannot be null");
        }
        this.declaredAnnotationMap = declaredAnnotationMap;
        this.declaredAnnotationSet = new HashSet<Annotation>();
        this.declaredMetaAnnotationMap = new MetaAnnotationMap();
        for (Annotation annotation : declaredAnnotationMap.values()) {
            for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                if (!AnnotatedItem.MAPPED_METAANNOTATIONS.contains(metaAnnotation.annotationType())) continue;
                this.declaredMetaAnnotationMap.put(metaAnnotation.annotationType(), annotation);
            }
            this.declaredAnnotationSet.add(annotation);
        }
    }

    public Set<Annotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotationSet);
    }

    public Set<Annotation> getMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet(this.metaAnnotationMap.get(metaAnnotationType));
    }

    public Set<Annotation> getDeclaredMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet(this.declaredMetaAnnotationMap.get(metaAnnotationType));
    }

    public Annotation[] getMetaAnnotationsAsArray(Class<? extends Annotation> metaAnnotationType) {
        return this.getMetaAnnotations(metaAnnotationType).toArray(EMPTY_ANNOTATION_ARRAY);
    }

    @Deprecated
    public Set<Annotation> getBindingTypes() {
        if (this.getMetaAnnotations(BindingType.class).size() > 0) {
            return Collections.unmodifiableSet(this.getMetaAnnotations(BindingType.class));
        }
        return Collections.unmodifiableSet(DEFAULT_BINDING);
    }

    @Deprecated
    public Annotation[] getBindingTypesAsArray() {
        return this.getBindingTypes().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    public <A extends Annotation> A getAnnotation(Class<? extends A> annotationType) {
        return (A)((Annotation)annotationType.cast(this.annotationMap.get(annotationType)));
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.annotationMap.containsKey(annotationType);
    }

    public boolean isDeclaredAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.declaredAnnotationMap.containsKey(annotationType);
    }

    AnnotationMap getAnnotationMap() {
        return this.annotationMap;
    }

    AnnotationMap getDeclaredAnnotationMap() {
        return this.declaredAnnotationMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetaAnnotationMap
    extends ForwardingMap<Class<? extends Annotation>, Set<Annotation>> {
        private final Map<Class<? extends Annotation>, Set<Annotation>> delegate = new HashMap<Class<? extends Annotation>, Set<Annotation>>();

        protected Map<Class<? extends Annotation>, Set<Annotation>> delegate() {
            return this.delegate;
        }

        public Set<Annotation> get(Object key) {
            Set annotations = (Set)super.get(key);
            return annotations != null ? annotations : new HashSet();
        }

        public void put(Class<? extends Annotation> key, Annotation value) {
            HashSet<Annotation> annotations = (HashSet<Annotation>)super.get(key);
            if (annotations == null) {
                annotations = new HashSet<Annotation>();
                super.put(key, annotations);
            }
            annotations.add(value);
        }

        public String toString() {
            return Strings.mapToString("MetaAnnotationMap (annotation type -> annotation set: ", this.delegate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotationMap
    extends ForwardingMap<Class<? extends Annotation>, Annotation> {
        private final Map<Class<? extends Annotation>, Annotation> delegate = new HashMap<Class<? extends Annotation>, Annotation>();

        protected Map<Class<? extends Annotation>, Annotation> delegate() {
            return this.delegate;
        }

        public String toString() {
            return Strings.mapToString("AnnotationMap (annotation type -> annotation): ", this.delegate);
        }
    }
}

