/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.util.Proxies;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotatedItem<T, S>
implements AnnotatedItem<T, S> {
    private String toString;
    private final AnnotationStore annotationStore;

    public AbstractAnnotatedItem(AnnotationStore annotatedItemHelper) {
        this.annotationStore = annotatedItemHelper;
    }

    @Override
    public AnnotationStore getAnnotationStore() {
        return this.annotationStore;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.getAnnotationStore().getAnnotation(annotationType);
    }

    @Override
    public Set<Annotation> getMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return this.getAnnotationStore().getMetaAnnotations(metaAnnotationType);
    }

    @Override
    public Set<Annotation> getDeclaredMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return this.getAnnotationStore().getDeclaredMetaAnnotations(metaAnnotationType);
    }

    @Override
    public Annotation[] getMetaAnnotationsAsArray(Class<? extends Annotation> metaAnnotationType) {
        return this.getMetaAnnotations(metaAnnotationType).toArray(new Annotation[0]);
    }

    @Override
    public Set<Annotation> getAnnotationsAsSet() {
        return this.getAnnotationStore().getAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotatedType) {
        return this.getAnnotationStore().isAnnotationPresent(annotatedType);
    }

    public boolean equals(Object other) {
        if (other instanceof AnnotatedItem) {
            AnnotatedItem that = (AnnotatedItem)other;
            return ((Object)this.getAnnotationsAsSet()).equals(that.getAnnotationsAsSet()) && this.getType().equals(that.getType());
        }
        return false;
    }

    @Override
    public boolean isAssignableFrom(AnnotatedItem<?, ?> that) {
        return this.isAssignableFrom(that.getType(), that.getActualTypeArguments());
    }

    @Override
    public boolean isAssignableFrom(Set<Type> types) {
        for (Type type : types) {
            Class clazz;
            if (!(type instanceof Class) || !this.isAssignableFrom(clazz = (Class)type, Reflections.getActualTypeArguments(clazz))) continue;
            return true;
        }
        return false;
    }

    private boolean isAssignableFrom(Class<?> type, Type[] actualTypeArguments) {
        return Types.boxedType(this.getType()).isAssignableFrom(Types.boxedType(type)) && Arrays.equals(this.getActualTypeArguments(), actualTypeArguments);
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Abstract annotated item " + this.getName();
        return this.toString;
    }

    @Override
    @Deprecated
    public Set<Annotation> getBindingTypes() {
        return this.getAnnotationStore().getBindingTypes();
    }

    @Override
    @Deprecated
    public Annotation[] getBindingTypesAsArray() {
        return this.getAnnotationStore().getBindingTypesAsArray();
    }

    @Override
    public boolean isProxyable() {
        return Proxies.isClassProxyable(this.getType());
    }

    public abstract S getDelegate();

    @Override
    public boolean isDeclaredAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotationStore().isDeclaredAnnotationPresent(annotationType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface WrappableAnnotatedItem<T, S>
    extends AnnotatedItem<T, S> {
        @Override
        public AnnotationStore getAnnotationStore();
    }
}

