/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import com.google.common.collect.ForwardingMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.BindingType;
import javax.inject.manager.Manager;
import org.jboss.webbeans.introspector.AnnotatedMember;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.ForwardingAnnotatedMember;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedItem;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotatedMember<T, S extends Member>
extends AbstractAnnotatedItem<T, S>
implements AnnotatedMember<T, S> {
    private final String name;
    private String toString;
    private final boolean _public;

    public AbstractAnnotatedMember(AnnotationStore annotatedItemHelper, Member member) {
        super(annotatedItemHelper);
        this.name = member.getName();
        this._public = Modifier.isPublic(member.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Reflections.isStatic((Member)this.getDelegate());
    }

    @Override
    public boolean isFinal() {
        return Reflections.isFinal((Member)this.getDelegate());
    }

    public boolean isTransient() {
        return Reflections.isTransient((Member)this.getDelegate());
    }

    @Override
    public boolean isPublic() {
        return this._public;
    }

    public T getValue(Manager manager) {
        return (T)manager.getInstanceByType(this.getType(), this.getMetaAnnotationsAsArray(BindingType.class));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Abstract annotated member " + this.getName();
        return this.toString;
    }

    @Override
    public S getMember() {
        return (S)((Member)this.getDelegate());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AnnotatedParameterMap
    extends ForwardingMap<Class<? extends Annotation>, List<AnnotatedParameter<?>>> {
        private Map<Class<? extends Annotation>, List<AnnotatedParameter<?>>> delegate = new HashMap();

        protected Map<Class<? extends Annotation>, List<AnnotatedParameter<?>>> delegate() {
            return this.delegate;
        }

        public void put(Class<? extends Annotation> key, AnnotatedParameter<?> value) {
            ArrayList parameters = (ArrayList)super.get(key);
            if (parameters == null) {
                parameters = new ArrayList();
                super.put(key, parameters);
            }
            parameters.add(value);
        }

        public String toString() {
            return Strings.mapToString("AnnotatedParameterMap (annotation type -> parameter abstraction list): ", this.delegate);
        }

        public List<AnnotatedParameter<?>> get(Object key) {
            List parameters = (List)super.get(key);
            return parameters != null ? parameters : new ArrayList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class WrappableForwardingAnnotatedMember<T, S extends Member>
    extends ForwardingAnnotatedMember<T, S>
    implements AbstractAnnotatedItem.WrappableAnnotatedItem<T, S> {
        WrappableForwardingAnnotatedMember() {
        }
    }
}

