/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import com.google.common.collect.ForwardingMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.webbeans.introspector.AnnotatedAnnotation;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedType;
import org.jboss.webbeans.introspector.jlr.AnnotatedMethodImpl;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedAnnotationImpl<T extends Annotation>
extends AbstractAnnotatedType<T>
implements AnnotatedAnnotation<T> {
    private final AnnotatedMemberMap annotatedMembers;
    private final Class<T> clazz;
    private final Set<AnnotatedMethod<?>> members;
    private String toString;

    public AnnotatedAnnotationImpl(Class<T> annotationType) {
        super(AnnotationStore.of(annotationType), annotationType);
        this.clazz = annotationType;
        this.members = new HashSet();
        this.annotatedMembers = new AnnotatedMemberMap();
        for (Method member : this.clazz.getDeclaredMethods()) {
            AnnotatedMethodImpl annotatedMethod = AnnotatedMethodImpl.of(member, this);
            this.members.add(annotatedMethod);
            for (Annotation annotation : annotatedMethod.getAnnotationsAsSet()) {
                this.annotatedMembers.put(annotation.annotationType(), annotatedMethod);
            }
        }
    }

    @Override
    public Type[] getActualTypeArguments() {
        return new Type[0];
    }

    @Override
    public Set<AnnotatedMethod<?>> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    @Override
    public Class<T> getType() {
        return this.clazz;
    }

    @Override
    public Set<AnnotatedMethod<?>> getAnnotatedMembers(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedMembers.get(annotationType));
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        return this.toString;
    }

    @Override
    public Class<T> getDelegate() {
        return this.clazz;
    }

    public AnnotatedAnnotation<T> wrap(Set<Annotation> annotations) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotatedMemberMap
    extends ForwardingMap<Class<? extends Annotation>, Set<AnnotatedMethod<?>>> {
        private Map<Class<? extends Annotation>, Set<AnnotatedMethod<?>>> delegate = new HashMap();

        protected Map<Class<? extends Annotation>, Set<AnnotatedMethod<?>>> delegate() {
            return this.delegate;
        }

        public String toString() {
            return Strings.mapToString("AnnotatedMemberMap (annotation type -> set of member abstractions: ", this.delegate);
        }

        public Set<AnnotatedMethod<?>> get(Object key) {
            Set methods = (Set)super.get(key);
            return methods != null ? methods : new HashSet();
        }

        public void put(Class<? extends Annotation> key, AnnotatedMethod<?> value) {
            HashSet members = (HashSet)super.get(key);
            if (members == null) {
                members = new HashSet();
                super.put(key, members);
            }
            members.add(value);
        }
    }
}

