/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import com.google.common.collect.ForwardingMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.TypeLiteral;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedConstructor;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedType;
import org.jboss.webbeans.introspector.jlr.AnnotatedConstructorImpl;
import org.jboss.webbeans.introspector.jlr.AnnotatedFieldImpl;
import org.jboss.webbeans.introspector.jlr.AnnotatedMethodImpl;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedClassImpl<T>
extends AbstractAnnotatedType<T>
implements AnnotatedClass<T> {
    private final Class<T> clazz;
    private final Type[] actualTypeArguments;
    private final Set<AnnotatedField<?>> fields;
    private final AnnotatedFieldMap annotatedFields;
    private final AnnotatedFieldMap metaAnnotatedFields;
    private final Set<AnnotatedField<?>> declaredFields;
    private final AnnotatedFieldMap declaredAnnotatedFields;
    private final AnnotatedFieldMap declaredMetaAnnotatedFields;
    private final Set<AnnotatedMethod<?>> methods;
    private final AnnotatedMethodMap annotatedMethods;
    private final AnnotatedMethodMap methodsByAnnotatedParameters;
    private final Set<AnnotatedMethod<?>> declaredMethods;
    private final AnnotatedMethodMap declaredAnnotatedMethods;
    private final AnnotatedMethodMap declaredMethodsByAnnotatedParameters;
    private final Set<AnnotatedConstructor<T>> constructors;
    private final AnnotatedConstructorMap annotatedConstructors;
    private final ConstructorsByArgumentMap constructorsByArgumentMap;
    private String toString;
    private final boolean _nonStaticMemberClass;
    private final boolean _parameterizedType;

    public static <T> AnnotatedClass<T> of(Class<T> clazz) {
        return new AnnotatedClassImpl<T>(clazz, clazz, clazz.getAnnotations(), clazz.getDeclaredAnnotations());
    }

    @Deprecated
    public static <T> AnnotatedClassImpl<T> of(TypeLiteral<T> typeLiteral, Annotation[] annotations) {
        return new AnnotatedClassImpl<T>(typeLiteral.getRawType(), typeLiteral.getType(), annotations, annotations);
    }

    @Deprecated
    public static <T> AnnotatedClassImpl<T> of(Class<T> clazz, Annotation[] annotations) {
        return new AnnotatedClassImpl<T>(clazz, clazz, annotations, annotations);
    }

    private AnnotatedClassImpl(Class<T> rawType, Type type, Annotation[] annotations, Annotation[] declaredAnnotations) {
        super(AnnotationStore.of(annotations, declaredAnnotations), rawType);
        Class<T> c;
        this.clazz = rawType;
        this.actualTypeArguments = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments() : new Type[0];
        this.fields = new HashSet();
        this.annotatedFields = new AnnotatedFieldMap();
        this.metaAnnotatedFields = new AnnotatedFieldMap();
        this.declaredFields = new HashSet();
        this.declaredAnnotatedFields = new AnnotatedFieldMap();
        this.declaredMetaAnnotatedFields = new AnnotatedFieldMap();
        this._nonStaticMemberClass = Reflections.isNonMemberInnerClass(rawType);
        this._parameterizedType = Reflections.isParameterizedType(rawType);
        for (c = this.clazz; c != Object.class && c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                AnnotatedFieldImpl annotatedField = new AnnotatedFieldImpl(field, this);
                this.fields.add(annotatedField);
                if (c == this.clazz) {
                    this.declaredFields.add(annotatedField);
                }
                for (Annotation annotation : annotatedField.getAnnotationsAsSet()) {
                    this.annotatedFields.put(annotation.annotationType(), annotatedField);
                    if (c == this.clazz) {
                        this.declaredAnnotatedFields.put(annotation.annotationType(), annotatedField);
                    }
                    for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                        this.metaAnnotatedFields.put(metaAnnotation.annotationType(), annotatedField);
                        if (c != this.clazz) continue;
                        this.declaredMetaAnnotatedFields.put(metaAnnotation.annotationType(), annotatedField);
                    }
                }
            }
        }
        this.constructors = new HashSet<AnnotatedConstructor<T>>();
        this.constructorsByArgumentMap = new ConstructorsByArgumentMap();
        this.annotatedConstructors = new AnnotatedConstructorMap();
        Constructor<?>[] arr$ = this.clazz.getDeclaredConstructors();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Constructor<?> constructor;
            Constructor<?> c2 = constructor = arr$[i$];
            AnnotatedConstructor<?> annotatedConstructor = AnnotatedConstructorImpl.of(c2, this);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            this.constructors.add(annotatedConstructor);
            this.constructorsByArgumentMap.put(Arrays.asList(constructor.getParameterTypes()), annotatedConstructor);
            for (Annotation annotation : annotatedConstructor.getAnnotationsAsSet()) {
                if (!this.annotatedConstructors.containsKey(annotation.annotationType())) {
                    this.annotatedConstructors.put(annotation.annotationType(), new HashSet());
                }
                this.annotatedConstructors.get(annotation.annotationType()).add(annotatedConstructor);
            }
        }
        this.methods = new HashSet();
        this.annotatedMethods = new AnnotatedMethodMap();
        this.methodsByAnnotatedParameters = new AnnotatedMethodMap();
        this.declaredMethods = new HashSet();
        this.declaredAnnotatedMethods = new AnnotatedMethodMap();
        this.declaredMethodsByAnnotatedParameters = new AnnotatedMethodMap();
        for (c = this.clazz; c != Object.class && c != null; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                AnnotatedMethodImpl annotatedMethod = AnnotatedMethodImpl.of(method, this);
                this.methods.add(annotatedMethod);
                if (c == this.clazz) {
                    this.declaredMethods.add(annotatedMethod);
                }
                for (Annotation annotation : annotatedMethod.getAnnotationsAsSet()) {
                    this.annotatedMethods.put(annotation.annotationType(), annotatedMethod);
                    if (c != this.clazz) continue;
                    this.declaredAnnotatedMethods.put(annotation.annotationType(), annotatedMethod);
                }
                for (Class clazz : AnnotatedMethod.MAPPED_PARAMETER_ANNOTATIONS) {
                    if (annotatedMethod.getAnnotatedParameters(clazz).size() <= 0) continue;
                    this.methodsByAnnotatedParameters.put(clazz, annotatedMethod);
                    if (c != this.clazz) continue;
                    this.declaredMethodsByAnnotatedParameters.put(clazz, annotatedMethod);
                }
            }
        }
    }

    public Class<? extends T> getAnnotatedClass() {
        return this.clazz;
    }

    @Override
    public Class<T> getDelegate() {
        return this.clazz;
    }

    @Override
    public Set<AnnotatedField<?>> getFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    public Set<AnnotatedField<?>> getDeclaredFields() {
        return Collections.unmodifiableSet(this.declaredFields);
    }

    @Override
    public Set<AnnotatedField<?>> getDeclaredAnnotatedFields(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.declaredAnnotatedFields.get(annotationType));
    }

    @Override
    public Set<AnnotatedConstructor<T>> getConstructors() {
        return Collections.unmodifiableSet(this.constructors);
    }

    @Override
    public Set<AnnotatedField<?>> getMetaAnnotatedFields(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet(this.metaAnnotatedFields.get(metaAnnotationType));
    }

    @Override
    public Set<AnnotatedField<?>> getAnnotatedFields(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedFields.get(annotationType));
    }

    @Override
    public Class<T> getType() {
        return this.clazz;
    }

    @Override
    public boolean isNonStaticMemberClass() {
        return this._nonStaticMemberClass;
    }

    @Override
    public boolean isParameterizedType() {
        return this._parameterizedType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public Set<AnnotatedMethod<?>> getAnnotatedMethods(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedMethods.get(annotationType));
    }

    @Override
    public Set<AnnotatedMethod<?>> getDeclaredAnnotatedMethods(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.declaredAnnotatedMethods.get(annotationType));
    }

    @Override
    public Set<AnnotatedConstructor<T>> getAnnotatedConstructors(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedConstructors.get(annotationType));
    }

    @Override
    public AnnotatedConstructor<T> getConstructor(List<Class<?>> arguments) {
        return (AnnotatedConstructor)this.constructorsByArgumentMap.get(arguments);
    }

    @Override
    public Set<AnnotatedMethod<?>> getMethodsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.methodsByAnnotatedParameters.get(annotationType));
    }

    @Override
    public Set<AnnotatedMethod<?>> getDeclaredMethodsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.declaredMethodsByAnnotatedParameters.get(annotationType));
    }

    @Override
    public AnnotatedMethod<?> getMethod(Method methodDescriptor) {
        for (AnnotatedMethod<?> annotatedMethod : this.methods) {
            if (!annotatedMethod.getName().equals(methodDescriptor.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), methodDescriptor.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public AnnotatedMethod<?> getDeclaredMethod(Method method) {
        for (AnnotatedMethod<?> annotatedMethod : this.declaredMethods) {
            if (!annotatedMethod.getName().equals(method.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), method.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Annotated class " + Names.classToString(this.getDelegate());
        return this.toString;
    }

    public AnnotatedClass<T> wrap(Set<Annotation> annotations) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstructorsByArgumentMap
    extends ForwardingMap<List<Class<?>>, AnnotatedConstructor<T>> {
        private Map<List<Class<?>>, AnnotatedConstructor<T>> delegate = new HashMap();

        protected Map<List<Class<?>>, AnnotatedConstructor<T>> delegate() {
            return this.delegate;
        }

        public String toString() {
            return Strings.mapToString("Annotation type -> constructor by arguments mappings: ", this.delegate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotatedConstructorMap
    extends ForwardingMap<Class<? extends Annotation>, Set<AnnotatedConstructor<T>>> {
        private Map<Class<? extends Annotation>, Set<AnnotatedConstructor<T>>> delegate = new HashMap();

        protected Map<Class<? extends Annotation>, Set<AnnotatedConstructor<T>>> delegate() {
            return this.delegate;
        }

        public String toString() {
            return Strings.mapToString("AnnotatedConstructorMap (annotation type -> constructor abstraction set): ", this.delegate);
        }

        public Set<AnnotatedConstructor<T>> get(Object key) {
            Set constructors = (Set)super.get(key);
            return constructors != null ? constructors : new HashSet();
        }

        public void add(Class<? extends Annotation> key, AnnotatedConstructor<T> value) {
            HashSet constructors = (HashSet)super.get(key);
            if (constructors == null) {
                constructors = new HashSet();
                super.put(key, constructors);
            }
            constructors.add(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotatedMethodMap
    extends ForwardingMap<Class<? extends Annotation>, Set<AnnotatedMethod<?>>> {
        private Map<Class<? extends Annotation>, Set<AnnotatedMethod<?>>> delegate = new HashMap();

        protected Map<Class<? extends Annotation>, Set<AnnotatedMethod<?>>> delegate() {
            return this.delegate;
        }

        public String toString() {
            return Strings.mapToString("AnnotatedMethodMap (annotation type -> method abstraction set): ", this.delegate);
        }

        public Set<AnnotatedMethod<?>> get(Object key) {
            Set methods = (Set)super.get(key);
            return methods != null ? methods : new HashSet();
        }

        public void put(Class<? extends Annotation> key, AnnotatedMethod<?> value) {
            HashSet methods = (HashSet)super.get(key);
            if (methods == null) {
                methods = new HashSet();
                super.put(key, methods);
            }
            methods.add(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotatedFieldMap
    extends ForwardingMap<Class<? extends Annotation>, Set<AnnotatedField<?>>> {
        private Map<Class<? extends Annotation>, Set<AnnotatedField<?>>> delegate = new HashMap();

        protected Map<Class<? extends Annotation>, Set<AnnotatedField<?>>> delegate() {
            return this.delegate;
        }

        public String toString() {
            return Strings.mapToString("AnnotatedFieldMap (annotation type -> field abstraction set): ", this.delegate);
        }

        public Set<AnnotatedField<?>> get(Object key) {
            Set fields = (Set)super.get(key);
            return fields != null ? fields : new HashSet();
        }

        public void put(Class<? extends Annotation> key, AnnotatedField<?> value) {
            HashSet fields = (HashSet)super.get(key);
            if (fields == null) {
                fields = new HashSet();
                super.put(key, fields);
            }
            fields.add(value);
        }
    }
}

