/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.introspector.AnnotatedType;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedMember;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedFieldImpl<T>
extends AbstractAnnotatedMember<T, Field>
implements AnnotatedField<T> {
    private final Type[] actualTypeArguments;
    private final Field field;
    private final AnnotatedType<?> declaringClass;
    private String toString;

    public AnnotatedFieldImpl(Field field, AnnotatedType<?> declaringClass) {
        super(AnnotationStore.of(field), field);
        this.field = field;
        field.setAccessible(true);
        this.declaringClass = declaringClass;
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            this.actualTypeArguments = type.getActualTypeArguments();
        } else {
            this.actualTypeArguments = new Type[0];
        }
    }

    @Override
    public Field getAnnotatedField() {
        return this.field;
    }

    @Override
    public Field getDelegate() {
        return this.field;
    }

    @Override
    public Class<T> getType() {
        return this.field.getType();
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public void set(Object instance, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.field.set(instance, value);
    }

    @Override
    public void setOnInstance(Object instance, Object value) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        instance.getClass().getField(this.getName()).set(instance, value);
    }

    @Override
    public T get(Object instance) {
        return (T)Reflections.getAndWrap(this.getDelegate(), instance);
    }

    @Override
    public String getPropertyName() {
        return this.getName();
    }

    @Override
    public AnnotatedType<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = Names.fieldToString(this.field) + " on " + this.getDeclaringClass();
        return this.toString;
    }
}

