/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import javax.annotation.NonBinding;
import javax.inject.BindingType;
import javax.inject.DefinitionException;
import javax.inject.ExecutionException;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.metadata.AnnotationModel;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingTypeModel<T extends Annotation>
extends AnnotationModel<T> {
    private Set<AnnotatedMethod<?>> nonBindingTypes;

    public BindingTypeModel(Class<T> type) {
        super(type);
    }

    @Override
    protected void init() {
        super.init();
        this.initNonBindingTypes();
        this.checkArrayAndAnnotationValuedMembers();
    }

    private void checkArrayAndAnnotationValuedMembers() {
        for (AnnotatedMethod<?> annotatedMethod : this.getAnnotatedAnnotation().getMembers()) {
            if (!Reflections.isArrayType(annotatedMethod.getType()) && !Annotation.class.isAssignableFrom(annotatedMethod.getType()) || this.nonBindingTypes.contains(annotatedMethod)) continue;
            throw new DefinitionException("Member of array type or annotation type must be annotated @NonBinding " + annotatedMethod);
        }
    }

    @Override
    protected Class<? extends Annotation> getMetaAnnotation() {
        return BindingType.class;
    }

    public boolean hasNonBindingTypes() {
        return this.nonBindingTypes.size() > 0;
    }

    public Set<AnnotatedMethod<?>> getNonBindingTypes() {
        return this.nonBindingTypes;
    }

    protected void initNonBindingTypes() {
        this.nonBindingTypes = this.getAnnotatedAnnotation().getAnnotatedMembers(NonBinding.class);
    }

    public boolean isEqual(Annotation instance, Annotation other) {
        if (instance.annotationType().equals(this.getType()) && other.annotationType().equals(this.getType())) {
            for (AnnotatedMethod<?> annotatedMethod : this.getAnnotatedAnnotation().getMembers()) {
                if (this.nonBindingTypes.contains(annotatedMethod)) continue;
                try {
                    Object thatValue;
                    Object thisValue = annotatedMethod.invoke(instance, new Object[0]);
                    if (thisValue.equals(thatValue = annotatedMethod.invoke(other, new Object[0]))) continue;
                    return false;
                }
                catch (IllegalArgumentException e) {
                    throw new ExecutionException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ExecutionException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new ExecutionException((Throwable)e);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return (this.isValid() ? "Valid" : "Invalid") + " binding type model for " + this.getType() + " with non-binding types " + this.getNonBindingTypes();
    }
}

