/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.metadata;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Named;
import javax.annotation.Stereotype;
import javax.context.ScopeType;
import javax.inject.BindingType;
import javax.inject.DefinitionException;
import javax.inject.DeploymentType;
import javax.interceptor.InterceptorBindingType;
import org.jboss.webbeans.metadata.AnnotationModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeModel<T extends Annotation>
extends AnnotationModel<T> {
    private Annotation defaultDeploymentType;
    private Annotation defaultScopeType;
    private boolean beanNameDefaulted;
    private Set<Class<? extends Annotation>> supportedScopes;
    private Set<Class<?>> requiredTypes;
    private Set<Annotation> interceptorBindings;

    public StereotypeModel(Class<T> sterotype) {
        super(sterotype);
        this.initDefaultDeploymentType();
        this.initDefaultScopeType();
        this.initBeanNameDefaulted();
        this.initSupportedScopes();
        this.initRequiredTypes();
        this.initInterceptorBindings();
        this.checkBindingTypes();
    }

    private void checkBindingTypes() {
        Set<Annotation> bindingTypes = this.getAnnotatedAnnotation().getMetaAnnotations(BindingType.class);
        if (bindingTypes.size() > 0) {
            throw new DefinitionException("Cannot declare binding types on a stereotype " + this.getAnnotatedAnnotation());
        }
    }

    private void initInterceptorBindings() {
        this.interceptorBindings = this.getAnnotatedAnnotation().getMetaAnnotations(InterceptorBindingType.class);
    }

    private void initSupportedScopes() {
        this.supportedScopes = new HashSet<Class<? extends Annotation>>();
        Class[] supportedScopes = this.getAnnotatedAnnotation().getAnnotation(Stereotype.class).supportedScopes();
        if (supportedScopes.length > 0) {
            this.supportedScopes.addAll(Arrays.asList(supportedScopes));
        }
    }

    private void initRequiredTypes() {
        this.requiredTypes = new HashSet();
        Class[] requiredTypes = this.getAnnotatedAnnotation().getAnnotation(Stereotype.class).requiredTypes();
        if (requiredTypes.length > 0) {
            this.requiredTypes.addAll(Arrays.asList(requiredTypes));
        }
    }

    private void initBeanNameDefaulted() {
        if (this.getAnnotatedAnnotation().isAnnotationPresent(Named.class)) {
            if (!"".equals(this.getAnnotatedAnnotation().getAnnotation(Named.class).value())) {
                throw new DefinitionException("Cannot specify a value for a @Named stereotype " + this.getAnnotatedAnnotation());
            }
            this.beanNameDefaulted = true;
        }
    }

    private void initDefaultScopeType() {
        Set<Annotation> scopeTypes = this.getAnnotatedAnnotation().getMetaAnnotations(ScopeType.class);
        if (scopeTypes.size() > 1) {
            throw new DefinitionException("At most one scope type may be specified for " + this.getAnnotatedAnnotation());
        }
        if (scopeTypes.size() == 1) {
            this.defaultScopeType = scopeTypes.iterator().next();
        }
    }

    private void initDefaultDeploymentType() {
        Set<Annotation> deploymentTypes = this.getAnnotatedAnnotation().getMetaAnnotations(DeploymentType.class);
        if (deploymentTypes.size() > 1) {
            throw new DefinitionException("At most one deployment type may be specified on " + this.getAnnotatedAnnotation());
        }
        if (deploymentTypes.size() == 1) {
            this.defaultDeploymentType = deploymentTypes.iterator().next();
        }
    }

    public Annotation getDefaultDeploymentType() {
        return this.defaultDeploymentType;
    }

    public Annotation getDefaultScopeType() {
        return this.defaultScopeType;
    }

    public Set<Annotation> getInterceptorBindings() {
        return this.interceptorBindings;
    }

    public boolean isBeanNameDefaulted() {
        return this.beanNameDefaulted;
    }

    public Set<Class<? extends Annotation>> getSupportedScopes() {
        return this.supportedScopes;
    }

    public Set<Class<?>> getRequiredTypes() {
        return this.requiredTypes;
    }

    @Deprecated
    public Class<? extends Annotation> getStereotypeClass() {
        return this.getType();
    }

    @Override
    public String toString() {
        return "Stereotype model with required types " + this.requiredTypes + " and supported scopes " + this.supportedScopes;
    }

    @Override
    protected Class<? extends Annotation> getMetaAnnotation() {
        return Stereotype.class;
    }
}

