/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.resource;

import java.util.ArrayList;
import java.util.List;
import javax.inject.ExecutionException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.webbeans.resources.spi.NamingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNamingContext
implements NamingContext {
    public abstract Context getContext();

    public void bind(String key, Object value) {
        try {
            List<String> parts = AbstractNamingContext.splitIntoContexts(key);
            Context context = this.getContext();
            for (int i = 0; i < parts.size() - 1; ++i) {
                context = (Context)context.lookup(parts.get(i));
            }
            context.bind(parts.get(parts.size() - 1), value);
        }
        catch (NamingException e) {
            throw new ExecutionException("Cannot bind " + value + " to " + key, (Throwable)e);
        }
    }

    public <T> T lookup(String name, Class<? extends T> expectedType) {
        Object instance;
        try {
            instance = this.getContext().lookup(name);
        }
        catch (NamingException e) {
            throw new ExecutionException("Cannot lookup " + name, (Throwable)e);
        }
        try {
            return expectedType.cast(instance);
        }
        catch (ClassCastException e) {
            throw new ExecutionException(instance + " not of expected type " + expectedType, (Throwable)e);
        }
    }

    private static List<String> splitIntoContexts(String key) {
        ArrayList<String> parts = new ArrayList<String>();
        for (String part : key.split("/")) {
            parts.add(part);
        }
        return parts;
    }
}

