/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.servlet;

import java.lang.reflect.Constructor;
import javax.servlet.ServletContext;
import org.jboss.webbeans.bootstrap.PropertiesBasedBootstrap;
import org.jboss.webbeans.bootstrap.SimpleResourceLoader;
import org.jboss.webbeans.bootstrap.spi.EjbDiscovery;
import org.jboss.webbeans.bootstrap.spi.WebBeanDiscovery;
import org.jboss.webbeans.context.ApplicationContext;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.context.RequestContext;
import org.jboss.webbeans.context.SessionContext;
import org.jboss.webbeans.ejb.spi.EjbResolver;
import org.jboss.webbeans.resource.DefaultNaming;
import org.jboss.webbeans.resources.spi.NamingContext;
import org.jboss.webbeans.resources.spi.ResourceLoader;
import org.jboss.webbeans.servlet.ApplicationBeanMap;
import org.jboss.webbeans.util.DeploymentProperties;

public class ServletBootstrap
extends PropertiesBasedBootstrap {
    private final ResourceLoader resourceLoader;
    private final WebBeanDiscovery webBeanDiscovery;
    private final EjbDiscovery ejbDiscovery;
    private final DeploymentProperties deploymentProperties;

    public ServletBootstrap(ServletContext servletContext) {
        SimpleResourceLoader temporaryResourceLoader = new SimpleResourceLoader();
        this.deploymentProperties = new DeploymentProperties(temporaryResourceLoader);
        this.resourceLoader = this.createResourceLoader(servletContext, temporaryResourceLoader);
        this.initManager(servletContext);
        this.webBeanDiscovery = this.createWebBeanDiscovery(servletContext);
        this.ejbDiscovery = this.createEjbDiscovery(servletContext);
        this.getManager().addContext(DependentContext.INSTANCE);
        this.getManager().addContext(RequestContext.INSTANCE);
        this.getManager().addContext(SessionContext.INSTANCE);
        this.getManager().addContext(ApplicationContext.INSTANCE);
        ApplicationContext.INSTANCE.setBeanMap(new ApplicationBeanMap(servletContext));
    }

    private void initManager(ServletContext servletContext) {
        this.initManager(this.createNaming(servletContext), this.createEjbResolver(servletContext), this.getResourceLoader());
    }

    protected NamingContext createNaming(ServletContext servletContext) {
        Constructor<NamingContext> namingConstructor = ServletBootstrap.getClassConstructor(this.getDeploymentProperties(), this.getResourceLoader(), NamingContext.PROPERTY_NAME, NamingContext.class, ServletContext.class);
        if (namingConstructor != null) {
            return ServletBootstrap.newInstance(namingConstructor, servletContext);
        }
        return new DefaultNaming();
    }

    protected EjbResolver createEjbResolver(ServletContext servletContext) {
        Constructor<EjbResolver> constructor = ServletBootstrap.getClassConstructor(this.getDeploymentProperties(), this.getResourceLoader(), EjbResolver.PROPERTY_NAME, EjbResolver.class, ServletContext.class);
        if (constructor != null) {
            return ServletBootstrap.newInstance(constructor, servletContext);
        }
        throw new IllegalStateException("Unable to find a EjbResolver, check Web Beans is correctly installed in your container");
    }

    protected EjbDiscovery createEjbDiscovery(ServletContext servletContext) {
        Constructor<EjbDiscovery> constructor = ServletBootstrap.getClassConstructor(this.getDeploymentProperties(), this.getResourceLoader(), EjbDiscovery.PROPERTY_NAME, EjbDiscovery.class, ServletContext.class);
        if (constructor != null) {
            return ServletBootstrap.newInstance(constructor, servletContext);
        }
        throw new IllegalStateException("Unable to find a EjbDiscovery, check Web Beans is correctly installed in your container");
    }

    protected WebBeanDiscovery createWebBeanDiscovery(ServletContext servletContext) {
        Constructor<WebBeanDiscovery> webBeanDiscoveryConstructor = ServletBootstrap.getClassConstructor(this.deploymentProperties, this.resourceLoader, WebBeanDiscovery.PROPERTY_NAME, WebBeanDiscovery.class, ServletContext.class);
        if (webBeanDiscoveryConstructor == null) {
            throw new IllegalStateException("Cannot load Web Bean discovery plugin! Check if Web Beans is properly installed into your container");
        }
        return ServletBootstrap.newInstance(webBeanDiscoveryConstructor, servletContext);
    }

    protected ResourceLoader createResourceLoader(ServletContext servletContext, ResourceLoader resourceLoader) {
        Constructor<ResourceLoader> resourceLoaderConstructor = ServletBootstrap.getClassConstructor(this.deploymentProperties, resourceLoader, ResourceLoader.PROPERTY_NAME, ResourceLoader.class, ServletContext.class);
        if (resourceLoaderConstructor != null) {
            return ServletBootstrap.newInstance(resourceLoaderConstructor, servletContext);
        }
        return resourceLoader;
    }

    protected DeploymentProperties getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    protected WebBeanDiscovery getWebBeanDiscovery() {
        return this.webBeanDiscovery;
    }

    protected EjbDiscovery getEjbDiscovery() {
        return this.ejbDiscovery;
    }
}

