/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.servlet;

import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.jboss.webbeans.resources.spi.ResourceLoader;
import org.jboss.webbeans.resources.spi.ResourceLoadingException;
import org.jboss.webbeans.util.EnumerationIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContextResourceLoader
implements ResourceLoader {
    private final ServletContext servletContext;

    public ServletContextResourceLoader(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Class<?> classForName(String name) {
        try {
            return this.servletContext.getClass().getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException((Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            throw new ResourceLoadingException((Throwable)e);
        }
    }

    public URL getResource(String name) {
        URL resource = this.getResourceFromServletContext(name);
        if (resource == null) {
            String stripped = name.startsWith("/") ? name.substring(1) : name;
            resource = this.servletContext.getClass().getClassLoader().getResource(stripped);
        }
        return resource;
    }

    private URL getResourceFromServletContext(String name) {
        try {
            return this.servletContext.getResource(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Iterable<URL> getResources(String name) {
        try {
            return new EnumerationIterable<URL>(this.servletContext.getClass().getClassLoader().getResources(name));
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Error loading resources for " + name, (Throwable)e);
        }
    }
}

