/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.servlet;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.webbeans.context.ApplicationContext;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.context.RequestContext;
import org.jboss.webbeans.context.SessionContext;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.servlet.ServletBootstrap;
import org.jboss.webbeans.servlet.SessionBeanMap;

public class ServletLifecycle {
    private static LogProvider log = Logging.getLogProvider(ServletLifecycle.class);

    public static void beginApplication(ServletContext servletContext) {
        new ServletBootstrap(servletContext).boot();
    }

    public static void endApplication() {
        ApplicationContext.INSTANCE.destroy();
        ApplicationContext.INSTANCE.setBeanMap(null);
    }

    public static void beginSession(HttpSession session) {
    }

    public static void endSession(HttpSession session) {
        SessionContext.INSTANCE.setBeanMap(new SessionBeanMap(session));
        SessionContext.INSTANCE.destroy();
        SessionContext.INSTANCE.setBeanMap(null);
    }

    public static void beginRequest(HttpServletRequest request) {
        SessionContext.INSTANCE.setBeanMap(new SessionBeanMap(request.getSession()));
        DependentContext.INSTANCE.setActive(true);
    }

    public static void endRequest(HttpServletRequest request) {
        DependentContext.INSTANCE.setActive(false);
        RequestContext.INSTANCE.destroy();
        SessionContext.INSTANCE.setBeanMap(null);
    }
}

