/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.util;

import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.manager.Bean;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.metadata.MetaDataCache;
import org.jboss.webbeans.util.Proxies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Beans {
    public static boolean isPassivatingBean(Bean<?> bean) {
        if (bean instanceof EnterpriseBean) {
            return ((EnterpriseBean)bean).getEjbDescriptor().isStateful();
        }
        return MetaDataCache.instance().getScopeModel(bean.getScopeType()).isPassivating();
    }

    public static boolean isBeanProxyable(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isProxyable();
        }
        return Beans.apiTypesAreProxyable(bean.getTypes());
    }

    public static boolean apiTypesAreProxyable(Set<Type> types) {
        for (Type apiType : types) {
            boolean isClass;
            if (Object.class.equals((Object)apiType) || !(isClass = !((Class)apiType).isInterface()) || Proxies.isClassProxyable((Class)apiType)) continue;
            return false;
        }
        return true;
    }
}

