/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.resources.spi.ResourceLoader;
import org.jboss.webbeans.resources.spi.ResourceLoadingException;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentProperties {
    public static final String RESOURCE_BUNDLE = "META-INF/web-beans-ri.properties";
    private static LogProvider log = Logging.getLogProvider(DeploymentProperties.class);
    private ResourceLoader resourceLoader;

    public DeploymentProperties(ResourceLoader classLoader) {
        this.resourceLoader = classLoader;
    }

    public List<String> getPropertyValues(String key) {
        ArrayList<String> values = new ArrayList<String>();
        this.addPropertiesFromSystem(key, values);
        this.addPropertiesFromResourceBundle(key, values);
        return values;
    }

    private void addPropertiesFromSystem(String key, List<String> values) {
        this.addProperty(key, System.getProperty(key), values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPropertiesFromResourceBundle(String key, List<String> values) {
        try {
            for (URL url : this.resourceLoader.getResources(RESOURCE_BUNDLE)) {
                Properties properties = new Properties();
                InputStream propertyStream = url.openStream();
                try {
                    properties.load(propertyStream);
                    this.addProperty(key, properties.getProperty(key), values);
                }
                finally {
                    if (propertyStream == null) continue;
                    propertyStream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addProperty(String key, String value, List<String> values) {
        if (value != null) {
            String[] properties;
            for (String property : properties = Strings.split(value, ":")) {
                values.add(property);
            }
        }
    }

    public static <T> Set<Class<? extends T>> getClasses(DeploymentProperties deploymentProperties, ResourceLoader resourceLoader, String propertyName, Class<T> expectedType) {
        HashSet<Class<T>> classes = new HashSet<Class<T>>();
        for (String className : deploymentProperties.getPropertyValues(propertyName)) {
            try {
                Class classForName = resourceLoader.classForName(className);
                classes.add(classForName);
            }
            catch (ResourceLoadingException e) {
                log.debug("Unable to load class " + className + " for property " + propertyName, e);
            }
        }
        return classes;
    }
}

