/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.util;

import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javassist.util.proxy.ProxyFactory;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Proxies {
    public static ProxyFactory getProxyFactory(Set<Type> types) {
        return TypeInfo.ofTypes(types).createProxyFactory();
    }

    public static boolean isClassProxyable(Class<?> clazz) {
        if (Reflections.getConstructor(clazz, new Class[0]) == null) {
            return false;
        }
        if (Reflections.isTypeOrAnyMethodFinal(clazz)) {
            return false;
        }
        if (Reflections.isPrimitive(clazz)) {
            return false;
        }
        return !Reflections.isArrayType(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeInfo {
        private static final Class<?>[] EMPTY_INTERFACES_ARRAY = new Class[0];
        private final Set<Class<?>> interfaces = new LinkedHashSet();
        private final Set<Class<?>> classes = new LinkedHashSet();

        private TypeInfo() {
        }

        public Class<?> getSuperClass() {
            if (this.classes.isEmpty()) {
                throw new AssertionError((Object)"TypeInfo not properly initialized");
            }
            Iterator<Class<?>> it = this.classes.iterator();
            Class<?> superclass = it.next();
            while (it.hasNext()) {
                Class<?> clazz = it.next();
                if (!superclass.isAssignableFrom(clazz)) continue;
                superclass = clazz;
            }
            return superclass;
        }

        private Class<?>[] getInterfaces() {
            return this.interfaces.toArray(EMPTY_INTERFACES_ARRAY);
        }

        public ProxyFactory createProxyFactory() {
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setSuperclass(this.getSuperClass());
            proxyFactory.setInterfaces((Class[])this.getInterfaces());
            return proxyFactory;
        }

        private void add(Type type) {
            if (type instanceof Class) {
                Class clazz = (Class)type;
                if (clazz.isInterface()) {
                    this.interfaces.add(clazz);
                } else {
                    this.classes.add(clazz);
                }
            }
        }

        public static TypeInfo ofTypes(Set<Type> types) {
            TypeInfo typeInfo = new TypeInfo();
            for (Type type : types) {
                typeInfo.add(type);
            }
            return typeInfo;
        }

        public static TypeInfo ofClasses(Set<Class<?>> classes) {
            TypeInfo typeInfo = new TypeInfo();
            for (Class<?> type : classes) {
                typeInfo.add(type);
            }
            return typeInfo;
        }
    }
}

