/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.examples.permalink;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Model;
import javax.inject.Inject;
import org.jboss.weld.examples.permalink.BlogEntry;
import org.jboss.weld.examples.permalink.BlogEntryRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Model
public class Blog {
    private static final int PAGE_SIZE = 3;
    @Inject
    BlogEntryRepository repository;
    private Long entryId;
    private String category;
    private BlogEntry entry;
    private List<BlogEntry> entriesForPage;
    private List<String> categories;
    private boolean nextPageAvailable;
    private int page = 1;
    private String searchString;

    public Long getEntryId() {
        return this.entryId;
    }

    public void setEntryId(Long entryId) {
        this.entryId = entryId;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getSearchString() {
        return this.searchString == null || this.searchString.length() == 0 ? null : this.searchString;
    }

    public void setSearchString(String searchString) {
        if (searchString != null) {
            searchString = searchString.trim();
        }
        this.searchString = searchString;
    }

    public Integer getPage() {
        return this.page == 1 ? null : Integer.valueOf(this.page);
    }

    public void setPage(Integer page) {
        if (page == null) {
            this.page = 1;
        } else {
            if (page < 1) {
                throw new IllegalArgumentException("Page must be greater than or equal to 1");
            }
            this.page = page;
        }
    }

    public void loadCategories() {
        this.categories = this.retrieveCategories();
    }

    public void loadLatestEntries() {
        this.loadCategories();
        this.entriesForPage = this.searchString != null ? this.retrieveSearchResults() : this.retrieveLatestEntries();
    }

    public void loadLatestEntriesInCategory() {
        this.loadCategories();
        if (this.categories.contains(this.category)) {
            this.entriesForPage = this.searchString != null ? this.retrieveSearchResultsInCategory() : this.retrieveLatestEntriesInCategory();
        } else {
            this.category = null;
        }
    }

    public void loadEntry() {
        this.loadCategories();
        this.entry = this.retrieveSelectedEntry();
    }

    public boolean search() {
        this.page = 1;
        return true;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public List<String> getOtherCategories() {
        ArrayList<String> others = new ArrayList<String>();
        if (this.categories != null) {
            others.addAll(this.categories);
            others.remove(this.category);
        }
        return others;
    }

    public List<BlogEntry> getEntriesForPage() {
        return this.entriesForPage;
    }

    public Set<BlogEntry> getEntriesForPageAsSet() {
        return new LinkedHashSet<BlogEntry>(this.entriesForPage);
    }

    public int getNumEntriesOnPage() {
        return this.entriesForPage.size();
    }

    public BlogEntry getEntry() {
        return this.entry;
    }

    public int getPreviousPageWithFirstPageAsNumber() {
        assert (this.page > 1);
        return this.page - 1;
    }

    public Integer getPreviousPage() {
        assert (this.page > 1);
        return this.page > 2 ? Integer.valueOf(this.page - 1) : null;
    }

    public int getPageWithFirstPageAsNumber() {
        return this.page;
    }

    public int getNextPage() {
        return this.page + 1;
    }

    public boolean isNextPageAvailable() {
        return this.nextPageAvailable;
    }

    public boolean isPreviousPageAvailable() {
        return this.page > 1;
    }

    protected List<BlogEntry> retrieveLatestEntries() {
        List entries = this.repository.getLatestEntries((this.page - 1) * 3, 4);
        if (entries.isEmpty() && this.page > 1) {
            this.page = 1;
            entries = this.repository.getLatestEntries(0, 4);
        }
        return this.postProcessNavigationProbe(entries);
    }

    protected List<BlogEntry> retrieveSearchResults() {
        List entries = this.repository.searchEntries(this.searchString, (this.page - 1) * 3, 4);
        if (entries.isEmpty() && this.page > 1) {
            this.page = 1;
            entries = this.repository.searchEntries(this.searchString, 0, 4);
        }
        return this.postProcessNavigationProbe(entries);
    }

    protected List<BlogEntry> retrieveLatestEntriesInCategory() {
        List entries = this.repository.getLatestEntries(this.category, (this.page - 1) * 3, 4);
        if (entries.isEmpty() && this.page > 1) {
            this.page = 1;
            entries = this.repository.getLatestEntries(this.category, 0, 4);
        }
        return this.postProcessNavigationProbe(entries);
    }

    protected List<BlogEntry> retrieveSearchResultsInCategory() {
        List entries = this.repository.searchEntries(this.searchString, this.category, (this.page - 1) * 3, 4);
        if (entries.isEmpty() && this.page > 1) {
            this.page = 1;
            entries = this.repository.searchEntries(this.searchString, this.category, 0, 4);
        }
        return this.postProcessNavigationProbe(entries);
    }

    private List<BlogEntry> postProcessNavigationProbe(List<BlogEntry> entries) {
        if (entries.size() > 3) {
            this.nextPageAvailable = true;
            entries.remove(entries.size() - 1);
        } else {
            this.nextPageAvailable = false;
        }
        return entries;
    }

    protected BlogEntry retrieveSelectedEntry() {
        return this.repository.getEntry(this.entryId);
    }

    protected List<String> retrieveCategories() {
        return this.repository.getCategories();
    }
}

