/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.examples.permalink;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.weld.examples.permalink.BlogEntry;
import org.jboss.weld.examples.permalink.Comment;
import org.jboss.weld.examples.permalink.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class BlogEntryRepository
implements Repository {
    private static AtomicLong uniqueEntryId = new AtomicLong(0L);
    private static AtomicLong uniqueCommentId = new AtomicLong(0L);
    private final List<BlogEntry> entries = new ArrayList();
    private DateFormat dateParser;

    @PostConstruct
    public void seed() {
        this.entries.add(new BlogEntry(Long.valueOf(uniqueEntryId.incrementAndGet()), "Dan", "General", "My first post", this.parseDate("15/01/09 13:30"), "This is the obligatory first post."));
        this.entries.add(new BlogEntry(Long.valueOf(uniqueEntryId.incrementAndGet()), "Dan", "JSF 2", "View parameters", this.parseDate("16/01/09 15:12"), "One of the new features in JSF 2 is view parameters. If you are familiar with Seam, you will recognize them as page parameters. They bring the value binding concept to GET requests by allowing you to associate a request parameter with a EL value binding expression. You can witness view parameters in action in this demo. View parameters are especially useful for ensuring that the URL is always bookmarkable throughout the user's browsing session."));
        this.entries.add(new BlogEntry(Long.valueOf(uniqueEntryId.incrementAndGet()), "Dan", "JSF 2", "Bookmarkable links", this.parseDate("18/01/09 14:45"), "JSF finally has bookmarkable links. No more complaining that \"everything is a POST!\""));
        this.entries.add(new BlogEntry(Long.valueOf(uniqueEntryId.incrementAndGet()), "Dan", "Java EE", "What's new in Java EE 6", this.parseDate("20/01/09 08:15"), "JSF 2, JPA 2, EJB 3.1, Java Contexts and Dependency Injection (formally Web Beans) and more!"));
        this.entries.add(new BlogEntry(Long.valueOf(uniqueEntryId.incrementAndGet()), "Dan", "JSF 2", "Annotation nation", this.parseDate("22/01/09 10:34"), "You can finally free yourself from the tangles of XML and use annotations to define your managed beans. You put @ManagedBean on a class to define a managed bean and you annotate a field with @ManagedProperty to wire two beans together. If those annotations aren't enough to satisfy you, then check out JSR-299: Java Contexts and Dependency Injection. That spec uses annotations extensively and is a drop-in replacement for the JSF managed bean facility...and a much more capabable one at that!"));
        this.entries.add(new BlogEntry(Long.valueOf(uniqueEntryId.incrementAndGet()), "Dan", "JSF 2", "Mojarra == RI", this.parseDate("25/01/09 11:00"), "The JSF reference implementation finally has a name: Mojarra. Surprise, it's the name of a fish."));
        Collections.sort(this.entries, new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<BlogEntry> searchEntries(String searchString, int offset, int count) {
        if (count == 0) {
            return Collections.emptyList();
        }
        if (searchString == null || searchString.trim().length() == 0) {
            return this.getLatestEntries(offset, count);
        }
        searchString = searchString.trim().toLowerCase();
        ArrayList<BlogEntry> results = new ArrayList<BlogEntry>();
        int idx = 0;
        for (BlogEntry entry : this.entries) {
            if (!entry.getTitle().toLowerCase().contains(searchString) && !entry.getBody().toLowerCase().contains(searchString) || idx++ < offset) continue;
            results.add(entry);
            if (results.size() != count) continue;
            return results;
        }
        return results;
    }

    public List<BlogEntry> searchEntries(String searchString, String category, int offset, int count) {
        if (count == 0) {
            return Collections.emptyList();
        }
        if (category == null || category.trim().length() == 0) {
            return this.searchEntries(searchString, offset, count);
        }
        if (searchString == null || searchString.trim().length() == 0) {
            return this.getLatestEntries(offset, count);
        }
        category = category.trim();
        searchString = searchString.trim().toLowerCase();
        ArrayList<BlogEntry> results = new ArrayList<BlogEntry>();
        int idx = 0;
        for (BlogEntry entry : this.entries) {
            if (!entry.getCategory().equals(category) || !entry.getTitle().toLowerCase().contains(searchString) && !entry.getBody().toLowerCase().contains(searchString) || idx++ < offset) continue;
            results.add(entry);
            if (results.size() != count) continue;
            return results;
        }
        return results;
    }

    public List<BlogEntry> getLatestEntries(String category, int offset, int count) {
        if (count == 0) {
            return Collections.emptyList();
        }
        if (category == null || category.trim().length() == 0) {
            return this.getLatestEntries(offset, count);
        }
        category = category.trim();
        ArrayList<BlogEntry> results = new ArrayList<BlogEntry>();
        int idx = 0;
        for (BlogEntry entry : this.entries) {
            if (!entry.getCategory().equals(category) || idx++ < offset) continue;
            results.add(entry);
            if (results.size() != count) continue;
            return results;
        }
        return results;
    }

    public List<BlogEntry> getLatestEntries(int offset, int count) {
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList<BlogEntry> results = new ArrayList<BlogEntry>();
        int idx = 0;
        for (BlogEntry entry : this.entries) {
            if (idx++ < offset) continue;
            results.add(entry);
            if (results.size() != count) continue;
            return results;
        }
        return results;
    }

    public BlogEntry getEntry(Long entryId) {
        for (BlogEntry entry : this.entries) {
            if (!entry.getId().equals(entryId)) continue;
            return entry;
        }
        return null;
    }

    public List<String> getCategories() {
        ArrayList<String> categories = new ArrayList<String>();
        for (BlogEntry entry : this.entries) {
            if (categories.contains(entry.getCategory())) continue;
            categories.add(entry.getCategory());
        }
        Collections.sort(categories);
        return categories;
    }

    public void addComment(Comment comment, Long entryId) {
        this.addComment(comment, this.getEntry(entryId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComment(Comment comment, BlogEntry entry) {
        comment.setId(Long.valueOf(uniqueCommentId.incrementAndGet()));
        comment.setPostDate(new Date());
        comment.setEntry(entry);
        BlogEntry blogEntry = entry;
        synchronized (blogEntry) {
            entry.getComments().add(new Comment(comment));
        }
    }

    private Date parseDate(String dateString) {
        if (this.dateParser == null) {
            this.dateParser = DateFormat.getDateTimeInstance(3, 3, Locale.UK);
        }
        try {
            return this.dateParser.parse(dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

