/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.example.numberguess;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.weld.environment.se.example.numberguess.Generator;
import org.jboss.weld.environment.se.example.numberguess.MaxNumber;

@ApplicationScoped
public class Game {
    public static final int MAX_NUM_GUESSES = 10;
    private Integer number;
    private int guess = 0;
    private int smallest = 0;
    @Inject
    @MaxNumber
    private int maxNumber;
    private int biggest;
    private int remainingGuesses = 10;
    private boolean validNumberRange = true;
    @Inject
    Generator rndGenerator;

    public int getNumber() {
        return this.number;
    }

    public int getGuess() {
        return this.guess;
    }

    public void setGuess(int guess) {
        this.guess = guess;
    }

    public int getSmallest() {
        return this.smallest;
    }

    public int getBiggest() {
        return this.biggest;
    }

    public int getRemainingGuesses() {
        return this.remainingGuesses;
    }

    public boolean isValidNumberRange() {
        return this.validNumberRange;
    }

    public boolean isGameWon() {
        return this.guess == this.number;
    }

    public boolean isGameLost() {
        return this.guess != this.number && this.remainingGuesses <= 0;
    }

    public boolean check() {
        boolean result = false;
        if (this.checkNewNumberRangeIsValid()) {
            if (this.guess > this.number) {
                this.biggest = this.guess - 1;
            }
            if (this.guess < this.number) {
                this.smallest = this.guess + 1;
            }
            if (this.guess == this.number) {
                result = true;
            }
            --this.remainingGuesses;
        }
        return result;
    }

    private boolean checkNewNumberRangeIsValid() {
        this.validNumberRange = this.guess >= this.smallest && this.guess <= this.biggest;
        return this.validNumberRange;
    }

    @PostConstruct
    public void reset() {
        this.smallest = 0;
        this.guess = 0;
        this.remainingGuesses = 10;
        this.biggest = this.maxNumber;
        this.number = this.rndGenerator.next();
        System.out.println("psst! the number is " + this.number);
    }
}

