/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.example.numberguess;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.weld.environment.se.example.numberguess.Game;

@Dependent
public class MessageGenerator {
    @Inject
    private Game game;

    public String getChallengeMessage() {
        StringBuilder challengeMsg = new StringBuilder("I'm thinking of a number between ");
        challengeMsg.append(this.game.getSmallest());
        challengeMsg.append(" and ");
        challengeMsg.append(this.game.getBiggest());
        challengeMsg.append(". Can you guess what it is?");
        return challengeMsg.toString();
    }

    public String getResultMessage() {
        if (this.game.isGameWon()) {
            return "You guessed it! The number was " + this.game.getNumber();
        }
        if (this.game.isGameLost()) {
            return "You are fail! The number was " + this.game.getNumber();
        }
        if (!this.game.isValidNumberRange()) {
            return "Invalid number range!";
        }
        if (this.game.getRemainingGuesses() == 10) {
            return "What is your first guess?";
        }
        String direction = null;
        direction = this.game.getGuess() < this.game.getNumber() ? "Higher" : "Lower";
        return direction + "! You have " + this.game.getRemainingGuesses() + " guesses left.";
    }
}

