/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.example.numberguess;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import org.jboss.weld.environment.se.events.ContainerInitialized;
import org.jboss.weld.environment.se.example.numberguess.Game;
import org.jboss.weld.environment.se.example.numberguess.MessageGenerator;

@ApplicationScoped
public class NumberGuessFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    @Inject
    private Game game;
    @Inject
    private MessageGenerator msgGenerator;
    private JPanel borderPanel;
    private JPanel buttonPanel;
    private JPanel gamePanel;
    private JButton guessButton;
    private JTextField guessText;
    private JProgressBar guessesLeftBar;
    private JLabel guessremainLabel;
    private JPanel inputsPanel;
    private JLabel mainLabel;
    private JPanel mainMsgPanel;
    private JLabel messageLabel;
    private JPanel remainingGuessesPanel;
    private JButton replayBtn;

    public void start(@Observes ContainerInitialized event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NumberGuessFrame.this.initComponents();
                NumberGuessFrame.this.setVisible(true);
            }
        });
    }

    private void initComponents() {
        this.borderPanel = new JPanel();
        this.gamePanel = new JPanel();
        this.inputsPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.guessButton = new JButton();
        this.replayBtn = new JButton();
        this.guessText = new JTextField();
        this.remainingGuessesPanel = new JPanel();
        this.guessremainLabel = new JLabel();
        this.guessesLeftBar = new JProgressBar();
        this.mainMsgPanel = new JPanel();
        this.mainLabel = new JLabel();
        this.messageLabel = new JLabel();
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new CardLayout());
        this.borderPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.borderPanel.setLayout(new CardLayout());
        this.gamePanel.setLayout(new BorderLayout(6, 6));
        this.inputsPanel.setLayout(new BorderLayout(8, 8));
        this.buttonPanel.setLayout(new CardLayout());
        this.guessButton.setText("Guess");
        this.guessButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NumberGuessFrame.this.guessButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add((Component)this.guessButton, "card2");
        this.replayBtn.setText("Replay!");
        this.replayBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NumberGuessFrame.this.replayBtnActionPerformed(evt);
            }
        });
        this.buttonPanel.add((Component)this.replayBtn, "card3");
        this.inputsPanel.add((Component)this.buttonPanel, "After");
        this.inputsPanel.add((Component)this.guessText, "Center");
        this.gamePanel.add((Component)this.inputsPanel, "Center");
        this.remainingGuessesPanel.setLayout(new BorderLayout(8, 8));
        this.guessremainLabel.setText("Guesses remaining:  ");
        this.remainingGuessesPanel.add((Component)this.guessremainLabel, "Before");
        this.guessesLeftBar.setMaximum(10);
        this.guessesLeftBar.setValue(10);
        this.guessesLeftBar.setPreferredSize(new Dimension(10, 14));
        this.remainingGuessesPanel.add((Component)this.guessesLeftBar, "Center");
        this.gamePanel.add((Component)this.remainingGuessesPanel, "Last");
        this.mainMsgPanel.setLayout(new GridLayout(2, 1, 6, 6));
        this.mainLabel.setHorizontalAlignment(0);
        this.mainLabel.setText(this.msgGenerator.getChallengeMessage());
        this.mainMsgPanel.add(this.mainLabel);
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setText(this.msgGenerator.getResultMessage());
        this.mainMsgPanel.add(this.messageLabel);
        this.gamePanel.add((Component)this.mainMsgPanel, "First");
        this.borderPanel.add((Component)this.gamePanel, "card2");
        this.getContentPane().add((Component)this.borderPanel, "card2");
        this.pack();
    }

    private void guessButtonActionPerformed(ActionEvent evt) {
        int guess = -1;
        try {
            guess = Integer.parseInt(this.guessText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.game.setGuess(guess);
        this.game.check();
        this.refreshUI();
        if (this.game.isGameWon() || this.game.isGameLost()) {
            this.switchButtons();
        }
    }

    private void replayBtnActionPerformed(ActionEvent evt) {
        this.game.reset();
        this.refreshUI();
        this.switchButtons();
    }

    private void switchButtons() {
        CardLayout buttonLyt = (CardLayout)this.buttonPanel.getLayout();
        buttonLyt.next(this.buttonPanel);
    }

    private void refreshUI() {
        this.mainLabel.setText(this.msgGenerator.getChallengeMessage());
        this.messageLabel.setText(this.msgGenerator.getResultMessage());
        this.guessText.setText("");
        this.guessesLeftBar.setValue(this.game.getRemainingGuesses());
        this.guessText.requestFocus();
    }
}

