package org.jboss.weld.integration.injection;

import org.jboss.ejb3.BeanContext;
import org.jboss.injection.Injector;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.servlet.api.ServletServices;
import org.jboss.weld.integration.deployer.env.helpers.BootstrapBean;

/**
 * Injector for injecting Web Beans into Servlets and other Web Artifacts
 *
 * @author Marius Bogoevici
 */
public class WeldInjector implements Injector
{
   private BootstrapBean bootstrapBean;

   public WeldInjector(BootstrapBean bootstrapBean)
   {
      if (bootstrapBean == null)
         throw new IllegalArgumentException("Null bootstrap bean");

      this.bootstrapBean = bootstrapBean;
   }

   public Class getInjectionClass()
   {
      return null;
   }

   public void inject(BeanContext ctx)
   {
      //no-op
   }

   public void inject(Object instance)
   {
      // assume that the deployment is flat. If this changes, the servlet context
      // needs to be passed along
      ServletServices services = bootstrapBean.getDeployment().getServices().get(ServletServices.class);
      BeanDeploymentArchive beanDeploymentArchive = services.getBeanDeploymentArchive(null);
      NonContextualObjectInjectionHelper.injectNonContextualInstance(instance, bootstrapBean.getBootstrap().getManager(beanDeploymentArchive));
   }
}
