package org.jboss.weld.integration.deployer.jndi;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.jboss.logging.Logger;
import org.jboss.reloaded.naming.spi.JavaEEComponent;
import org.jboss.weld.integration.deployer.env.helpers.BootstrapBean;

/**
 * @author Marius Bogoevici
 */
public class JavaEEComponentJndiBinder
{
   private Logger log = Logger.getLogger(getClass());

   private BootstrapBean bootstrapBean;
   private JavaEEComponent javaEEComponent;
   private Context context;

   public JavaEEComponentJndiBinder(BootstrapBean bootstrapBean, JavaEEComponent javaEEComponent)
   {
      this.javaEEComponent = javaEEComponent;
      if (bootstrapBean == null)
         throw new RuntimeException("Bootstrap bean cannot be null");
      this.bootstrapBean = bootstrapBean;
   }

   public void bindToJavaComp()
   {
      try
      {
         context = javaEEComponent.getContext();
         context.bind("BeanManager",bootstrapBean.getBootstrap().getManager(bootstrapBean.getDeployment().getFlatBeanDeploymentArchive()));
      }
      catch (NamingException e)
      {
         log.error("No java:comp context found for " + javaEEComponent.getName());
      }
   }

   public void unbind()
   {
      try
      {
         context.unbind("BeanManager");
      }
      catch (NamingException e)
      {
         log.error("Cound not unbind java:comp/BeanManager");
      }
   }

}