package org.jboss.weld.integration.deployer.jndi;

import static org.jboss.reloaded.naming.deployers.util.AnnotationHelper.annotation;

import org.jboss.beans.metadata.api.model.InjectOption;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.plugins.graph.Search;
import org.jboss.dependency.spi.graph.SearchInfo;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.plugins.scope.ApplicationScope;
import org.jboss.metadata.plugins.scope.DeploymentScope;
import org.jboss.metadata.plugins.scope.InstanceScope;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;
import org.jboss.reloaded.naming.spi.JavaEEComponent;
import org.jboss.weld.integration.deployer.DeployersUtils;
import org.jboss.weld.integration.deployer.env.helpers.BootstrapBean;

/**
 * @author Marius Bogoevici
 */
public class JavaEEComponentJndiBinderDeployer extends AbstractSimpleRealDeployer<JBossEnterpriseBeanMetaData>
{

   private JavaEEComponentInformer informer;

   public JavaEEComponentJndiBinderDeployer(JavaEEComponentInformer javaEEComponentInformer)
   {
      super(JBossEnterpriseBeanMetaData.class);
      informer = javaEEComponentInformer;
      setComponentsOnly(true);
      setOutput(BeanMetaData.class);
   }

   @Override
   public void deploy(DeploymentUnit deploymentUnit, JBossEnterpriseBeanMetaData jBossEnterpriseBeanMetaData) throws DeploymentException
   {
      BeanMetaDataBuilder builder  = BeanMetaDataBuilder.createBuilder(deploymentUnit.getName() + "_CompJndiBinder", JavaEEComponentJndiBinder.class.getName());
      builder.addConstructorParameter(BootstrapBean.class.getName(), new AbstractInjectionValueMetaData(DeployersUtils.getBootstrapBeanName(deploymentUnit.getTopLevel())));
      AbstractInjectionValueMetaData javaComponent = new AbstractInjectionValueMetaData(getComponentBeanName(deploymentUnit));
      builder.addConstructorParameter(JavaEEComponent.class.getName(), javaComponent);
      builder.addInstall("bindToJavaComp");
      deploymentUnit.getParent().addAttachment(deploymentUnit.getName()+"/Comp", builder.getBeanMetaData());

   }

   private String getComponentBeanName(DeploymentUnit deploymentUnit)
   {
      String appName = informer.getApplicationName(deploymentUnit);
      String moduleName = informer.getModulePath(deploymentUnit);
      String componentName = informer.getComponentName(deploymentUnit);
      String name = "jboss.naming:";
      if(appName != null)
         name += "application=" + appName + ",";
      name += "module=" + moduleName + ",component=" + componentName;
      return name;
   }

}
