package org.jboss.weld.integration.deployer.jndi;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.jboss.logging.Logger;
import org.jboss.weld.integration.deployer.env.helpers.BootstrapBean;

/**
 * @author Marius Bogoevici
 */
public class WebCompJndiBinder
{
   private Logger log = Logger.getLogger(getClass());

   private BootstrapBean bootstrapBean;
   private String deploymentUnitName;
   private Context context;

   public WebCompJndiBinder(BootstrapBean bootstrapBean, String deploymentUnitName)
   {
      this.deploymentUnitName = deploymentUnitName;
      if (bootstrapBean == null)
         throw new RuntimeException("Bootstrap bean cannot be null");
      this.bootstrapBean = bootstrapBean;
   }

   public void bindToJavaComp()
   {
      try
      {
         context = ((Context) new InitialContext().lookup("java:comp/"));
         context.bind("BeanManager",bootstrapBean.getBootstrap().getManager(bootstrapBean.getDeployment().getFlatBeanDeploymentArchive()));
      }
      catch (NamingException e)
      {
         log.error("No java:comp context found for " + deploymentUnitName);
      }
   }


   public void unbind()
   {
      try
      {
         context.unbind("BeanManager");
      }
      catch (NamingException e)
      {
         log.error("Cound not unbind java:comp/BeanManager");
      }
   }
}
